package com.bxm.localnews.im.param;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.List;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "马甲号批量发送消息参数")
@Builder
public class BatchMessageParam extends BaseBean {
    @ApiModelProperty("发送消息类型,RC:TxtMsg 文本消息, RC:ImgMsg 图片消息")
    private String objectName;

    @ApiModelProperty("发送类型的内容")
    private String content;

    @ApiModelProperty("发送马甲号的用户id")
    private Long fromUserId;

    @ApiModelProperty("接收消息的用户id")
    private List<Long> toUserId;

    @Tolerate
    public BatchMessageParam() {
    }
}
