package com.bxm.localnews.im.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * @author Gonzo
 * @date 2019-10-30 17:30
 */
@Data
@ApiModel(description = "获取聊天室最近的红包信息请求参数")
public class ChatRoomNearestTimingRedPacketPlanInfoParam {

    @ApiModelProperty("聊天室id")
    @NotEmpty(message = "聊天室id不能为空")
    private String chatRoomId;

    @ApiModelProperty("当前用户ID")
    @NotNull(message = "用户id不能为空")
    private Long userId;
}
