package com.bxm.localnews.im.param;


import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@ApiModel(description = "群租操作参数")
@EqualsAndHashCode(callSuper = true)
@Data
public class ChatRoomOperationParam extends BaseBean {
    @ApiModelProperty(value = "聊天室ID", required = true)
    private String chatRoomId;

    @ApiModelProperty(value = "操作目标用户ID", required = true)
    private Long targetUserId;

    @ApiModelProperty(value = "操作用户ID", required = true)
    private Long userId;

    @ApiModelProperty("操作类型(0禁言一天,1永久禁言,2解除禁言,3消息撤回)")
    private Integer operationType;
}
