package com.bxm.localnews.im.param;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
@ApiModel(description = "用户加入聊天室参数")
@Builder
public class JoinChatroomParam extends BaseBean {
    @Tolerate
    public JoinChatroomParam(){
    }
    @ApiModelProperty("地区编码")
    @NotBlank
    private String areaCode;

    @ApiModelProperty("聊天室id")
    @NotBlank
    private String chatRoomId;

    @ApiModelProperty("用户id")
    @NotNull
    private Long userId;

}
