package com.bxm.localnews.im.param;

import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "打开红包参数")
@Data
public class OpenRedPackageParam extends BasicParam {

    @ApiModelProperty("打开红包的用户")
    @NotNull(message = "用户ID不能为空")
    private Long userId;

    @ApiModelProperty("定时红包ID")
    @NotNull(message = "红包ID不能为空")
    private Long redPackageId;

    @ApiModelProperty("基本请求参数 areaCode")
    private String areaCode;
}
