package com.bxm.localnews.im.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@ApiModel(description = "管理员操作群聊记录上报参数")
@Data
public class OperateParam {

	@ApiModelProperty("操作类型(0禁言一天,1永久禁言,2解除禁言,3消息撤回)")
	@NotNull
	private Integer operationType;

	@ApiModelProperty("操作类型对应id")
	@NotNull
	private String targetId;

	@ApiModelProperty("操作人id")
	@NotNull
	private Long userId;

	@ApiModelProperty("聊天室id")
	@NotNull
	private String chatRoomId;

}
