package com.bxm.localnews.im.param;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

@ApiModel(description = "红包开抢提醒")
@EqualsAndHashCode(callSuper = true)
@Data
public class RedPackageRemindParam extends BaseBean {

    @ApiModelProperty("提醒目标用户ID")
    @NotNull(message = "提醒目标用户ID不能为空")
    private Long userId;

    @ApiModelProperty("定时红包ID")
    @NotNull(message = "定时红包ID不能为空")
    private Long redPackageId;

    @ApiModelProperty("是否开启，true：开启，false：取消")
    @NotNull(message = "是否开启不能为空")
    private Boolean switchVal;
}
