package com.bxm.localnews.im.param;

import com.bxm.localnews.im.en.RedPacketAction;
import lombok.Builder;
import lombok.Data;

/**
 * @author Gonzo
 * @date 2019-11-05 10:53
 */
@Data
@Builder
public class RedPacketCacheClearParam {

    /**
     * 红包id
     */
    private Long redPacketId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 定时红包计划id
     */
    private Long timingRedPacketPlanId;

    /**
     * 是否延迟执行
     * 默认false
     */
    private Boolean delay = Boolean.FALSE;

    /**
     * 默认延迟两秒执行
     */
    private long delaySecond = 2;

    /**
     * 行为
     */
    private RedPacketAction action;
}
