package com.bxm.localnews.im.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author Gonzo
 * @date 2019-11-20 10:46
 */
@Data
@ApiModel(description = "上报已阅读小纸条 or 动态信息参数")
public class ReportReadParam {

    @ApiModelProperty("发起聊天的用户id")
    private Long userId;

    @ApiModelProperty("目标用户id")
    private Long targetUserId;

    @ApiModelProperty(value = "本次查看的目标用户的小纸条 or 动态id", example = "[1, 2, 3]")
    private List<Long> contentIds;

    @ApiModelProperty(value = "上报类型 1: 上报动态已读 2: 上报小纸条已读 eg: 1", example = "1")
    private Byte reportType;

}
