package com.bxm.localnews.im.vo;

import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.io.Serializable;
import java.util.Date;


@Data
@EqualsAndHashCode
@Builder
public class ImChatroom implements Serializable {

    private static final long serialVersionUID = -4650120839129524703L;
    /**
     * 开启定时红包
     */
    public final static byte OPEN_TIMING_REDPACKET = 1;
    /**
     * 关闭定时红包
     */
    public final static byte CLOSE_TIMING_REDPACKET = 0;
    /**
     * 开启聊天室
     */
    public final static byte OPEN_CHATROOM = 1;
    /**
     * 关闭聊天室
     */
    public final static byte CLOSE_CHATROOM = 0;

    @Tolerate
    public ImChatroom() {
    }

    private Long id;

    /**
     * 地区编码
     */
    private String areaCode;

    /**
     * 聊天室id
     */
    private String chatRoomId;

    /**
     * 聊天室名称
     */
    private String chatRoomName;

    /**
     * 是否开启定时红包(0:关闭  1:开启)
     */
    private Byte enableTimingRedPacket;

    /**
     * 是否开启聊天室(是否开启聊天室 0:关闭  1:开启)
     */
    private Byte enableChatRoom;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 聊天室虚拟人数最小值
     */
    private Integer startIntervalNumber;

    /**
     * 聊天室虚拟人数最小值
     */
    private Integer endIntervalNumber;


}