package com.bxm.localnews.im.vo;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * Created by Administrator on 2018/2/23.
 * 用户信息
 */
@ApiModel(description = "用户实体返回包装类")
@Data
public class UserInfo {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty("性别")
    private Byte sex;

    @ApiModelProperty("用户访问凭证")
    private String token;

    @ApiModelProperty("token过期时间")
    private Long expireTime;

    @ApiModelProperty("刷新token")
    private String refreshToken;

    @ApiModelProperty("是否是新用户")
    private Byte isNew;

    @ApiModelProperty("微信")
    private String weixin;

    @ApiModelProperty("状态")
    private Byte state;

    @ApiModelProperty("手机号")
    private String phone;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date createTime;

    @ApiModelProperty("生日(精确到日)")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT_YEAR_MONTH_DAY_FORMAT)
    private Date birthday;

    @ApiModelProperty(value = "用户是否使用的临时昵称 ps：0代表不能修改昵称了")
    private Byte isTempNickName;

    @ApiModelProperty("注册来源")
    private String registerChannel;

    @ApiModelProperty(value = "注册关联id")
    private Long relationId;

    @ApiModelProperty(value = "邀请人id")
    private Long inviteUserId;

    @ApiModelProperty("个人简介")
    private String personalProfile;

    @ApiModelProperty(value = "关注数量")
    private Integer attentionNum;

    @ApiModelProperty(value = "粉丝")
    private Integer fanNum;

    @ApiModelProperty(value = "点赞数")
    private Integer likeNum;

    @ApiModelProperty(value = "背景图")
    private String backgroundImgUrl;

    @ApiModelProperty(value = "是否默认个人简介 true 默认 false 不是默认")
    private Boolean isDefaultPersonalProfile;

    @ApiModelProperty("行业标签")
    private String industry;

    @ApiModelProperty(value = "情感状态 0：保密  1：单身  2：恋爱中  3：已婚")
    private Byte relationshipStatus;

    @ApiModelProperty(value = "家乡地区编码")
    private String hometownCode;

    @ApiModelProperty(value = "家乡名称")
    private String hometownName;

    @ApiModelProperty(value = "当前地区编码")
    private String locationCode;

    @ApiModelProperty(value = "当前地区名称")
    private String locationName;

}
