/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.im.common.constant.IMRedisKey;
import com.bxm.localnews.im.domain.MessageMapper;
import com.bxm.localnews.im.integration.MsgIntegrationService;
import com.bxm.localnews.im.param.RongCloudParam;
import com.bxm.localnews.im.service.ConsumService;
import com.bxm.localnews.im.thirdpart.MsgContentProcesser;
import com.bxm.localnews.im.thirdpart.enums.MsgTypeEnum;
import com.bxm.localnews.im.thirdpart.rongcloud.RCProcesserFactory;
import com.bxm.localnews.im.vo.IMMessageBean;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumServiceImpl
implements ConsumService {
    private static final Logger log = LoggerFactory.getLogger(ConsumServiceImpl.class);
    private final RedisSetAdapter redisSetAdapter;
    private final MsgIntegrationService msgIntegrationService;
    private AtomicBoolean conditon = new AtomicBoolean(true);
    private Thread consumThread;

    @Autowired
    public ConsumServiceImpl(RedisSetAdapter redisSetAdapter, MsgIntegrationService msgIntegrationService) {
        this.redisSetAdapter = redisSetAdapter;
        this.msgIntegrationService = msgIntegrationService;
    }

    @Override
    public void active() {
        if (this.conditon.get()) {
            log.debug("\u89e6\u53d1\u6d88\u8d39\u7ebf\u7a0b\u6210\u529f");
            this.conditon.set(false);
            try {
                this.consumThread.run();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            log.debug("\u672a\u80fd\u83b7\u53d6\u5230\u8fd0\u884c\u6807\u8bc6\uff0c\u6d88\u8d39\u7ebf\u7a0b\u8fd0\u884c\u4e2d");
        }
    }

    @PostConstruct
    public void init() {
        this.consumThread = new Thread("im-msg-consume-Thread"){

            @Override
            public void run() {
                try {
                    ConsumServiceImpl.this.consume();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    log.debug("\u6267\u884c\u5b8c\u6210\uff0c\u590d\u539f\u6807\u8bc6\u4f4d");
                    ConsumServiceImpl.this.conditon.set(true);
                }
            }
        };
        this.consumThread.start();
    }

    private void consume() {
        long size = this.redisSetAdapter.size(IMRedisKey.MSG_SET);
        long popSize = size > 100L ? 100L : size;
        log.debug("\u83b7\u53d6\u6d88\u606f\u603b\u6570\uff1a[{}]", (Object)size);
        if (popSize > 0L) {
            List msgList = this.redisSetAdapter.pop(IMRedisKey.MSG_SET, Long.valueOf(popSize), RongCloudParam.class);
            List<IMMessageBean> messages = this.convert(msgList);
            MybatisBatchBuilder.create(MessageMapper.class, messages).run(MessageMapper::insert);
            this.msgIntegrationService.addUnreadMsg(messages);
            log.debug("\u6d88\u606f\u5904\u7406\u5b8c\u6210\uff0c\u6d88\u606f\u6570\u91cf\uff1a[{}]", (Object)popSize);
            this.consume();
        }
    }

    private List<IMMessageBean> convert(List<RongCloudParam> msgList) {
        ArrayList messages = Lists.newArrayList();
        for (RongCloudParam paramMsg : msgList) {
            MsgContentProcesser processer = RCProcesserFactory.get(paramMsg.getObjectName());
            IMMessageBean message = this.build(paramMsg, processer);
            if (MsgTypeEnum.ACTION.equals((Object)processer.msgType())) {
                processer.callback(message);
                continue;
            }
            messages.add(message);
        }
        return messages;
    }

    private IMMessageBean build(RongCloudParam paramMsg, MsgContentProcesser processer) {
        String briefContent = processer.parseBrief(paramMsg.getContent());
        String parseContent = processer.parse(paramMsg.getContent());
        return IMMessageBean.builder().msgId(paramMsg.getMsgUID()).fromUserId(Long.valueOf(paramMsg.getFromUserId())).toUserId(Long.valueOf(paramMsg.getToUserId())).content(paramMsg.getContent()).briefContent(briefContent).parseContent(parseContent).msgTimestamp(new Date(Long.valueOf(paramMsg.getMsgTimestamp()))).channelType(paramMsg.getChannelType()).groupUserIds(StringUtils.join((Object[])paramMsg.getGroupUserIds(), (String)",")).sensitiveType(paramMsg.getSensitiveType()).source(paramMsg.getSource()).msgType(paramMsg.getObjectName()).build();
    }
}

