/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.localnews.im.common.constant.IMRedisKey;
import com.bxm.localnews.im.config.IMProperties;
import com.bxm.localnews.im.domain.MessageMapper;
import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.integration.MsgIntegrationService;
import com.bxm.localnews.im.integration.UserIntegrationService;
import com.bxm.localnews.im.param.ClearMessageParam;
import com.bxm.localnews.im.param.RongCloudParam;
import com.bxm.localnews.im.service.ConsumService;
import com.bxm.localnews.im.service.IMService;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IMServiceImpl
implements IMService {
    private static final Logger log = LoggerFactory.getLogger(IMServiceImpl.class);
    private final IMSDKAdapter imsdkAdapter;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserIntegrationService userIntegrationService;
    private final RedisSetAdapter redisSetAdapter;
    private final ConsumService consumService;
    private final MessageMapper messageMapper;
    private final MsgIntegrationService msgIntegrationService;
    private final IMProperties imProperties;

    @Autowired
    public IMServiceImpl(IMSDKAdapter imsdkAdapter, RedisHashMapAdapter redisHashMapAdapter, UserIntegrationService userIntegrationService, RedisSetAdapter redisSetAdapter, ConsumService consumService, MessageMapper messageMapper, MsgIntegrationService msgIntegrationService, IMProperties imProperties) {
        this.imsdkAdapter = imsdkAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userIntegrationService = userIntegrationService;
        this.redisSetAdapter = redisSetAdapter;
        this.consumService = consumService;
        this.messageMapper = messageMapper;
        this.msgIntegrationService = msgIntegrationService;
        this.imProperties = imProperties;
    }

    private KeyGenerator buildKey(Long userId) {
        return IMRedisKey.TOKEN.copy().appendKey((Object)(userId % 10L));
    }

    @Override
    public String getToken(Long userId) {
        log.debug("\u83b7\u53d6token\u5f00\u59cb\uff0c\u7528\u6237:[{}]", (Object)userId);
        Preconditions.checkArgument((null != userId ? 1 : 0) != 0);
        KeyGenerator key = this.buildKey(userId);
        String token = (String)this.redisHashMapAdapter.get(key, userId.toString(), String.class);
        if (null == token) {
            UserBean user = this.userIntegrationService.selectUserFromCache(userId);
            if (null == user || StringUtils.isEmpty((String)user.getNickname()) || StringUtils.isEmpty((String)user.getHeadImg())) {
                return "";
            }
            token = this.imsdkAdapter.token(user);
            if (StringUtils.isNotBlank((String)token)) {
                this.redisHashMapAdapter.put(key, userId.toString(), (Object)token);
            }
        }
        log.debug("\u83b7\u53d6\u7528\u6237:[{}],token:[{}]", (Object)userId, (Object)token);
        return token;
    }

    @Override
    public void updateUser(Long userId) {
        this.imsdkAdapter.update(this.userIntegrationService.selectUserFromCache(userId));
    }

    @Override
    public void write(RongCloudParam param) {
        log.debug("\u65b0\u589e\u4e00\u6761\u901a\u8baf\u6d88\u606f\uff1a[{}]", (Object)param);
        this.redisSetAdapter.add(IMRedisKey.MSG_SET, new Object[]{param});
        this.consumService.active();
    }

    @Override
    public void remove(ClearMessageParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        Preconditions.checkArgument((param.getUserId() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((param.getSessionUserId() != null ? 1 : 0) != 0);
        if (param.getClearPoint() == null) {
            param.setClearPoint(new Date());
        }
        this.messageMapper.remove(param);
        this.redisHashMapAdapter.remove(IMRedisKey.UN_READ_MSG.copy().appendKey((Object)param.getUserId()), new String[]{String.valueOf(param.getSessionUserId())});
        this.redisHashMapAdapter.remove(IMRedisKey.LAST_MSG.copy().appendKey((Object)param.getUserId()), new String[]{String.valueOf(param.getSessionUserId())});
    }

    @Override
    public void countAndPush() {
        int monitorNum = this.imProperties.getMonitorNum();
        Date startTime = DateUtils.clearTimePart((Date)new Date());
        Date endTime = DateUtils.setField((Date)startTime, (int)11, (int)this.imProperties.getTriggerHour());
        int total = this.messageMapper.sendUserCount(startTime, endTime);
        List monitorUserIds = this.messageMapper.queryMonitorUserIds(startTime, endTime, monitorNum);
        StringBuilder content = new StringBuilder();
        content.append("--------").append(DateUtils.formatDateTime((Date)endTime)).append("--------\n");
        content.append("\u4eca\u65e5\u53d1\u8d77\u79c1\u804a\u4eba\u6570\uff1a[").append(total).append("]\n");
        content.append("\u4eca\u65e5\u53d1\u8d77\u79c1\u804a\u6570\u91cf\u8d85\u8fc7").append(monitorNum).append("\u6b21\u4ee5\u4e0a\u7684\u7528\u6237\uff1a\n");
        for (Long userId : monitorUserIds) {
            content.append("[").append(userId).append("]\n");
        }
        this.msgIntegrationService.pushIMGroup(content.toString());
    }
}

