/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.localnews.im.common.constant.IMRedisKey;
import com.bxm.localnews.im.domain.MessageMapper;
import com.bxm.localnews.im.dto.SessionInfoDto;
import com.bxm.localnews.im.integration.UserIntegrationService;
import com.bxm.localnews.im.service.UserService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    private final UserIntegrationService userIntegrationService;
    private final MessageMapper messageMapper;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private static final int MAX_SEND_MSG = 2;

    @Autowired
    public UserServiceImpl(UserIntegrationService userIntegrationService, MessageMapper messageMapper, RedisHashMapAdapter redisHashMapAdapter) {
        this.userIntegrationService = userIntegrationService;
        this.messageMapper = messageMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public SessionInfoDto get(Long fromUid, Long toUid) {
        Long sendMsgNum;
        SessionInfoDto session = new SessionInfoDto();
        session.setFollow(this.userIntegrationService.isFollow(fromUid, toUid));
        session.setAllowSend(Boolean.valueOf(true));
        if (!this.userIntegrationService.isFollow(toUid, fromUid).booleanValue() && null != (sendMsgNum = (Long)this.redisHashMapAdapter.get(this.buildKey(toUid), String.valueOf(fromUid), Long.class)) && sendMsgNum >= 2L) {
            Integer reply = this.messageMapper.hasReply(fromUid, toUid);
            if (null == reply || 0 == reply) {
                session.setAllowSend(Boolean.valueOf(false));
                session.setRejectMsg("\u5bf9\u65b9\u8fd8\u6ca1\u6709\u5173\u6ce8\u4f60\uff0c\u5728\u672a\u6536\u5230\u56de\u590d\u524d\u4e0d\u80fd\u518d\u7ee7\u7eed\u53d1\u6d88\u606f\u4e86");
            }
            log.debug("session:{},sendMsgNum:{}", (Object)session, (Object)sendMsgNum);
        }
        return session;
    }

    private KeyGenerator buildKey(Long userId) {
        return IMRedisKey.UN_READ_MSG.copy().appendKey((Object)userId);
    }
}

