/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.thirdpart.impl;

import com.bxm.localnews.im.config.IMProperties;
import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.newidea.component.vo.Message;
import io.rong.RongCloud;
import io.rong.models.Result;
import io.rong.models.response.ResponseResult;
import io.rong.models.response.TokenResult;
import io.rong.models.user.UserModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class RongCloudIMSDK
implements IMSDKAdapter,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RongCloudIMSDK.class);
    private RongCloud rongCloud;
    private final IMProperties imProperties;

    @Autowired
    public RongCloudIMSDK(IMProperties imProperties) {
        this.imProperties = imProperties;
    }

    @Override
    public String token(UserBean user) {
        UserModel model = this.build(user);
        try {
            log.debug("\u83b7\u53d6\u878d\u4e91token\u5f00\u59cb");
            TokenResult result = this.rongCloud.user.register(model);
            if (this.sussced((Result)result)) {
                log.debug("\u83b7\u53d6\u878d\u4e91token\u6210\u529f,user:[{}],token:[{}]", (Object)user, (Object)result);
                return result.getToken();
            }
            log.error("\u8c03\u7528\u878d\u4e91\u63a5\u53e3\u6ce8\u518c\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a[{}]", (Object)result);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u878d\u4e91rongCloud.user.register\u63a5\u53e3\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private UserModel build(UserBean user) {
        return new UserModel(user.getId().toString(), user.getNickname(), user.getHeadImg());
    }

    private boolean sussced(Result result) {
        return null != result && HttpStatus.OK.value() == result.getCode().intValue();
    }

    @Override
    public void update(UserBean user) {
        try {
            Result result = this.rongCloud.user.update(this.build(user));
            if (!this.sussced(result)) {
                log.error("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a[{}]", (Object)result);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u878d\u4e91rongCloud.user.update\u63a5\u53e3\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public Message block(Long userId, int mintues) {
        UserModel user = new UserModel();
        user.setMinute(Integer.valueOf(mintues));
        user.setId(String.valueOf(userId));
        try {
            Result result = this.rongCloud.user.block.add(user);
            if (!this.sussced(result)) {
                log.error("\u5c01\u7981\u7528\u6237\u8c03\u7528\u5931\u8d25\uff0c\u5c01\u7981\u7528\u6237\uff1a[{}]\uff0c\u5c01\u7981\u65f6\u957f\uff1a[{}],\u8fd4\u56de\u7ed3\u679c\uff1a[{}]", new Object[]{userId, mintues, result});
                return Message.build((boolean)false);
            }
            log.debug("\u5c01\u7981\u7528\u6237\u6210\u529f\uff0c\u7528\u6237ID:[{}],\u5c01\u7981\u65f6\u957f\uff1a[{}],\u64cd\u4f5c\u7ed3\u679c:[{}]", new Object[]{userId, mintues, result});
        }
        catch (Exception e) {
            log.error("\u5c01\u7981\u7528\u6237\u8c03\u7528\u5931\u8d25\uff0c\u5c01\u7981\u7528\u6237\uff1a[{}]\uff0c\u5c01\u7981\u65f6\u957f\uff1a[{}]", (Object)userId, (Object)mintues);
            log.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false, (String)e.getMessage());
        }
        return Message.build();
    }

    @Override
    public Message unblock(Long userId) {
        try {
            ResponseResult result = this.rongCloud.user.block.remove(String.valueOf(userId));
            if (this.sussced((Result)result)) {
                log.debug("\u89e3\u9664\u5c01\u7981\u7528\u6237\u6210\u529f\uff0c\u7528\u6237ID:[{}],\u64cd\u4f5c\u7ed3\u679c\uff1a[{}]", (Object)userId, (Object)result);
            } else {
                log.error("\u89e3\u9664\u7528\u6237\u5c01\u7981\u5931\u8d25\uff0c\u7528\u6237ID\uff1a[{}]\uff0c\u64cd\u4f5c\u7ed3\u679c\uff1a[{}]", (Object)userId, (Object)result);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u9664\u7528\u6237\u5c01\u7981\u5931\u8d25\uff0c\u7528\u6237ID\uff1a[{}]", (Object)userId);
            log.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false, (String)e.getMessage());
        }
        return Message.build();
    }

    public void afterPropertiesSet() {
        this.rongCloud = RongCloud.getInstance((String)this.imProperties.getRongcloudAppKey(), (String)this.imProperties.getRongcloudAppSecret());
    }
}

