/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.im.common.constant.IMRedisKey;
import com.bxm.localnews.im.config.ChatRoomRecordProperties;
import com.bxm.localnews.im.domain.ChatroomOperateHistoryMapper;
import com.bxm.localnews.im.domain.ImChatroomMapper;
import com.bxm.localnews.im.domain.MessageMapper;
import com.bxm.localnews.im.dto.BlockUserDTO;
import com.bxm.localnews.im.dto.ChatRoomBlockUser;
import com.bxm.localnews.im.dto.GroupInfoDto;
import com.bxm.localnews.im.dto.LocationDTO;
import com.bxm.localnews.im.enums.ChannelTypeEnum;
import com.bxm.localnews.im.enums.ChatRoomOperationEnum;
import com.bxm.localnews.im.integration.LocationIntegrationService;
import com.bxm.localnews.im.integration.UserIntegrationService;
import com.bxm.localnews.im.param.ChatRoomMuteParam;
import com.bxm.localnews.im.param.ChatRoomOperationParam;
import com.bxm.localnews.im.param.MessageWithdrawParam;
import com.bxm.localnews.im.param.OperateParam;
import com.bxm.localnews.im.service.ChatRoomService;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.vo.ChatroomOperateHistory;
import com.bxm.localnews.im.vo.IMMessageBean;
import com.bxm.localnews.im.vo.ImChatroom;
import com.bxm.localnews.im.vo.UserInfo;
import com.bxm.localnews.im.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.rong.models.chatroom.BlockMuteUser;
import io.rong.models.chatroom.ChatroomMember;
import io.rong.models.response.ChatroomUserQueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ChatRoomServiceImpl
extends BaseService
implements ChatRoomService {
    private final ImChatroomMapper imChatroomMapper;
    private final IMSDKAdapter imsdkAdapter;
    private final UserIntegrationService userIntegrationService;
    private final ChatroomOperateHistoryMapper chatroomOperateHistoryMapper;
    private final AsyncTaskExecutor asyncTaskExecutor;
    private final MessageMapper messageMapper;
    private final RedisListAdapter redisListAdapter;
    private final ChatRoomRecordProperties chatRoomRecordProperties;
    private final LocationIntegrationService locationIntegrationService;

    @Override
    public Boolean createChatRoom(String areaCode, Long assistantUserIds, String areaName) {
        ImChatroom imChatroom = this.imChatroomMapper.selectByAreaCode(areaCode);
        if (Objects.isNull(imChatroom)) {
            Date currentDate = new Date();
            String chatRoomId = String.valueOf(this.nextId());
            String chatRoomTitle = areaName + "\u4eba";
            Boolean flag = this.imsdkAdapter.createChatRoom(chatRoomId, assistantUserIds, chatRoomTitle);
            this.logger.debug("\u521b\u5efa\u804a\u5929\u5ba4\u5e76\u4fdd\u6d3b:[{}]", (Object)flag);
            if (flag.booleanValue()) {
                ImChatroom room = ImChatroom.builder().areaCode(areaCode).chatRoomId(chatRoomId).id(Long.valueOf(this.nextId())).createTime(currentDate).enableTimingRedPacket(Byte.valueOf((byte)0)).enableChatRoom(Byte.valueOf((byte)0)).modifyTime(currentDate).chatRoomName(areaName + "\u4eba").build();
                this.imChatroomMapper.insertSelective(room);
            }
            return flag;
        }
        return Boolean.TRUE;
    }

    @Override
    public int submitChatroomOperate(OperateParam operateParam) {
        ChatroomOperateHistory record = new ChatroomOperateHistory();
        BeanUtils.copyProperties((Object)operateParam, (Object)record);
        record.setId(Long.valueOf(this.nextId()));
        record.setOperationTime(new Date());
        return this.chatroomOperateHistoryMapper.insertSelective(record);
    }

    @Override
    public Message block(ChatRoomMuteParam param) {
        Message message = Message.build((boolean)this.imsdkAdapter.chatRoomBlock(param));
        this.coverOperation((ChatRoomOperationParam)param);
        return message;
    }

    @Override
    public Message unblock(ChatRoomOperationParam param) {
        Message message = Message.build((boolean)this.imsdkAdapter.chatRoomUnBlock(param));
        this.coverOperation(param);
        return message;
    }

    private void coverOperation(ChatRoomOperationParam param) {
        OperateParam operateParam = new OperateParam();
        operateParam.setChatRoomId(param.getChatRoomId());
        operateParam.setTargetId(String.valueOf(param.getTargetUserId()));
        operateParam.setUserId(param.getUserId());
        operateParam.setOperationType(param.getOperationType());
        this.submitChatroomOperate(operateParam);
    }

    @Override
    public GroupInfoDto getChatRoomInfoByAreaCode(String areaCode) {
        ImChatroom imChatroom = this.imChatroomMapper.selectByAreaCode(areaCode);
        if (Objects.nonNull(imChatroom) && imChatroom.getEnableChatRoom() == 1) {
            ChatroomUserQueryResult result = this.imsdkAdapter.getChatRoomUser(imChatroom.getChatRoomId());
            List<String> joinUserList = this.getUserHeadImg(result.getMembers());
            int virtualNum = this.getJoinUserList(imChatroom, joinUserList);
            List<String> copyWrite = this.getCopyWrite(imChatroom);
            return GroupInfoDto.builder().chatRoomId(imChatroom.getChatRoomId()).hasRedPackage(imChatroom.getEnableTimingRedPacket() == 1).joinNum(result.getTotal()).joinUserList(joinUserList).intervalNumber(Integer.valueOf(virtualNum)).copyWriter(copyWrite).build();
        }
        return null;
    }

    private int getJoinUserList(ImChatroom imChatroom, List<String> joinUserList) {
        boolean intervalflag;
        int virtualNum = 0;
        int size = 20;
        boolean bl = intervalflag = Objects.nonNull(imChatroom.getEndIntervalNumber()) && Objects.nonNull(imChatroom.getEndIntervalNumber()) && imChatroom.getStartIntervalNumber() >= 0 && imChatroom.getEndIntervalNumber().compareTo(imChatroom.getStartIntervalNumber()) > 0;
        if (intervalflag) {
            virtualNum = ThreadLocalRandom.current().nextInt(imChatroom.getStartIntervalNumber(), imChatroom.getEndIntervalNumber());
        }
        if (joinUserList.size() < 20) {
            List userList = this.userIntegrationService.getVirtualUserList(Integer.valueOf(20 - joinUserList.size()));
            List collect = userList.stream().map(VirtualUserInfo::getHeadImg).collect(Collectors.toList());
            joinUserList.addAll(collect);
        }
        return virtualNum;
    }

    private List<String> getCopyWrite(ImChatroom imChatroom) {
        int resultSize = 20;
        Byte enableTimingRedPacket = imChatroom.getEnableTimingRedPacket();
        ArrayList copyWrite = Lists.newArrayList();
        if (1 == enableTimingRedPacket) {
            copyWrite.add(this.chatRoomRecordProperties.getRedpacketRecord());
        } else {
            int size = this.chatRoomRecordProperties.getChatRecord().size();
            LocationDTO location = this.locationIntegrationService.getLocationByGeocode(imChatroom.getAreaCode());
            KeyGenerator recentKey = IMRedisKey.CHATROOM_RECENT_RECORD.copy().appendKey((Object)imChatroom.getChatRoomId());
            List realList = this.redisListAdapter.range(recentKey, 0L, (long)size, (TypeReference)new TypeReference<String>(){});
            if (realList.size() < 20) {
                ArrayList metaList = Lists.newArrayList();
                metaList.addAll(this.chatRoomRecordProperties.getChatRecord());
                for (int i = 0; i < size; ++i) {
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    int nextInt = random.nextInt(0, metaList.size());
                    String result = (String)metaList.remove(nextInt);
                    if (result.contains("%s")) {
                        result = String.format(result, location.getName());
                    }
                    realList.add(result);
                    if (realList.size() >= 20) break;
                }
            }
            copyWrite.addAll(realList);
        }
        return copyWrite;
    }

    @Override
    public ImChatroom getCharRoom(String areaCode) {
        Preconditions.checkArgument((null != areaCode ? 1 : 0) != 0);
        return this.imChatroomMapper.selectByAreaCode(areaCode);
    }

    private List<String> getUserHeadImg(List<ChatroomMember> members) {
        if (!CollectionUtils.isEmpty(members)) {
            List userIds = members.stream().map(e -> NumberUtils.toLong((String)e.getId())).collect(Collectors.toList());
            List userInfos = this.userIntegrationService.batchUserInfo(userIds);
            return userInfos.stream().map(UserInfo::getHeadImg).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ChatRoomBlockUser> blockList(String chatRoomId) {
        List<BlockMuteUser> list = this.imsdkAdapter.getChatRoomBlockList(chatRoomId);
        ArrayList result = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(e -> {
                ChatRoomBlockUser user = ChatRoomBlockUser.builder().chatroomId(chatRoomId).id(NumberUtils.createLong((String)e.getUserId())).time(DateUtils.parseDate((String)e.getTime())).build();
                result.add(user);
            });
        }
        return result;
    }

    @Override
    public List<BlockUserDTO> queryChatRoomBlockUser(String chatRoomId) {
        List<BlockMuteUser> list = this.imsdkAdapter.getChatRoomBlockList(chatRoomId);
        List userIds = list.stream().map(BlockMuteUser::getUserId).map(NumberUtils::toLong).collect(Collectors.toList());
        List userInfos = this.userIntegrationService.batchUserInfo(userIds);
        Map<Long, UserInfo> userMap = userInfos.stream().collect(Collectors.toMap(UserInfo::getId, userinfo -> userinfo));
        ArrayList result = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(e -> {
                UserInfo userInfo = (UserInfo)userMap.get(NumberUtils.toLong((String)e.getUserId()));
                BlockUserDTO user = new BlockUserDTO();
                user.setChatroomId(chatRoomId);
                user.setId(userInfo.getId());
                user.setHeadImg(userInfo.getHeadImg());
                user.setUserName(userInfo.getNickname());
                user.setTime(DateUtils.parseDateTime((String)e.getTime()));
                result.add(user);
            });
        }
        return result;
    }

    @Override
    public Message messageWithdraw(MessageWithdrawParam param) {
        Message message = this.imsdkAdapter.messageWithdraw(param);
        if (message.isSuccess()) {
            OperateParam operateParam = new OperateParam();
            operateParam.setOperationType(Integer.valueOf(ChatRoomOperationEnum.RECALL.getCode()));
            operateParam.setChatRoomId(param.getTargetId());
            operateParam.setUserId(param.getFromUserId());
            operateParam.setTargetId(param.getMessageUID());
            this.submitChatroomOperate(operateParam);
        }
        return message;
    }

    @Override
    @Async
    public void personRecall(IMMessageBean message) {
        if (StringUtils.notEquals((CharSequence)ChannelTypeEnum.TEMPGROUP.getTypeName(), (CharSequence)message.getChannelType())) {
            OperateParam param = new OperateParam();
            param.setOperationType(Integer.valueOf(ChatRoomOperationEnum.PERSON_RECALL.getCode()));
            param.setUserId(message.getFromUserId());
            String content = message.getContent();
            JSONObject jsonObject = JSONObject.parseObject((String)content);
            param.setTargetId(jsonObject.getString("messageUId"));
            param.setChatRoomId("");
            this.submitChatroomOperate(param);
        }
    }

    @Override
    public void syncChatRecord() {
        this.logger.debug("\u5f00\u59cb\u540c\u6b65\u804a\u5929\u5ba4\u6700\u8fd120\u6761\u8bb0\u5f55");
        List imChatrooms = this.imChatroomMapper.selectOpenChatRoom();
        CountDownLatch latch = new CountDownLatch(imChatrooms.size());
        for (ImChatroom chatroom : imChatrooms) {
            this.asyncTaskExecutor.execute(() -> {
                try {
                    String chatRoomId = chatroom.getChatRoomId();
                    List result = this.messageMapper.selectRecentRecord(chatRoomId);
                    KeyGenerator recentKey = IMRedisKey.CHATROOM_RECENT_RECORD.copy().appendKey((Object)chatRoomId);
                    this.redisListAdapter.remove(recentKey);
                    if (!CollectionUtils.isEmpty((Collection)result)) {
                        this.redisListAdapter.leftPush(recentKey, result.toArray());
                    }
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error("\u7b49\u5f85\u7ebf\u7a0b\u51fa\u9519", (Throwable)e);
        }
    }

    @Autowired
    public ChatRoomServiceImpl(ImChatroomMapper imChatroomMapper, IMSDKAdapter imsdkAdapter, UserIntegrationService userIntegrationService, ChatroomOperateHistoryMapper chatroomOperateHistoryMapper, AsyncTaskExecutor asyncTaskExecutor, MessageMapper messageMapper, RedisListAdapter redisListAdapter, ChatRoomRecordProperties chatRoomRecordProperties, LocationIntegrationService locationIntegrationService) {
        this.imChatroomMapper = imChatroomMapper;
        this.imsdkAdapter = imsdkAdapter;
        this.userIntegrationService = userIntegrationService;
        this.chatroomOperateHistoryMapper = chatroomOperateHistoryMapper;
        this.asyncTaskExecutor = asyncTaskExecutor;
        this.messageMapper = messageMapper;
        this.redisListAdapter = redisListAdapter;
        this.chatRoomRecordProperties = chatRoomRecordProperties;
        this.locationIntegrationService = locationIntegrationService;
    }
}

