/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.localnews.im.batchmessage.BatchMessageContext;
import com.bxm.localnews.im.common.constant.IMRedisKey;
import com.bxm.localnews.im.config.IMProperties;
import com.bxm.localnews.im.domain.MessageMapper;
import com.bxm.localnews.im.dto.LocationDTO;
import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.enums.ChannelTypeEnum;
import com.bxm.localnews.im.enums.ObjectNameEnum;
import com.bxm.localnews.im.integration.LocationIntegrationService;
import com.bxm.localnews.im.integration.MsgIntegrationService;
import com.bxm.localnews.im.integration.UserIntegrationService;
import com.bxm.localnews.im.param.BatchMessageParam;
import com.bxm.localnews.im.param.ClearMessageParam;
import com.bxm.localnews.im.param.RongCloudParam;
import com.bxm.localnews.im.service.ConsumService;
import com.bxm.localnews.im.service.IMService;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.vo.IMMessageBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.rong.messages.BaseMessage;
import io.rong.models.message.PrivateMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class IMServiceImpl
implements IMService {
    private static final Logger log = LoggerFactory.getLogger(IMServiceImpl.class);
    private final IMSDKAdapter imsdkAdapter;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserIntegrationService userIntegrationService;
    private final RedisSetAdapter redisSetAdapter;
    private final ConsumService consumService;
    private final MessageMapper messageMapper;
    private final MsgIntegrationService msgIntegrationService;
    private final IMProperties imProperties;
    private final BatchMessageContext batchMessageContext;
    private final LocationIntegrationService locationIntegrationService;

    @Autowired
    public IMServiceImpl(IMSDKAdapter imsdkAdapter, RedisHashMapAdapter redisHashMapAdapter, UserIntegrationService userIntegrationService, RedisSetAdapter redisSetAdapter, ConsumService consumService, MessageMapper messageMapper, MsgIntegrationService msgIntegrationService, IMProperties imProperties, BatchMessageContext batchMessageContext, LocationIntegrationService locationIntegrationService) {
        this.imsdkAdapter = imsdkAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userIntegrationService = userIntegrationService;
        this.redisSetAdapter = redisSetAdapter;
        this.consumService = consumService;
        this.messageMapper = messageMapper;
        this.msgIntegrationService = msgIntegrationService;
        this.imProperties = imProperties;
        this.batchMessageContext = batchMessageContext;
        this.locationIntegrationService = locationIntegrationService;
    }

    private KeyGenerator buildKey(Long userId) {
        return IMRedisKey.TOKEN.copy().appendKey((Object)(userId % 10L));
    }

    @Override
    public String getToken(Long userId) {
        log.debug("\u83b7\u53d6token\u5f00\u59cb\uff0c\u7528\u6237:[{}]", (Object)userId);
        Preconditions.checkArgument((null != userId ? 1 : 0) != 0);
        KeyGenerator key = this.buildKey(userId);
        String token = (String)this.redisHashMapAdapter.get(key, userId.toString(), String.class);
        if (null == token) {
            UserBean user = this.userIntegrationService.selectUserFromCache(userId);
            if (null == user || StringUtils.isEmpty((String)user.getNickname()) || StringUtils.isEmpty((String)user.getHeadImg())) {
                return "";
            }
            token = this.imsdkAdapter.token(user);
            if (StringUtils.isNotBlank((String)token)) {
                this.redisHashMapAdapter.put(key, userId.toString(), (Object)token);
            }
        }
        log.debug("\u83b7\u53d6\u7528\u6237:[{}],token:[{}]", (Object)userId, (Object)token);
        return token;
    }

    @Override
    public void updateUser(Long userId) {
        this.imsdkAdapter.update(this.userIntegrationService.selectUserFromCache(userId));
    }

    @Override
    public void write(RongCloudParam param) {
        log.debug("\u65b0\u589e\u4e00\u6761\u901a\u8baf\u6d88\u606f\uff1a[{}]", (Object)param);
        this.redisSetAdapter.add(IMRedisKey.MSG_SET, new Object[]{param});
        this.consumService.active();
    }

    @Override
    public void remove(ClearMessageParam param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0);
        Preconditions.checkArgument((param.getUserId() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((param.getSessionUserId() != null ? 1 : 0) != 0);
        if (param.getClearPoint() == null) {
            param.setClearPoint(new Date());
        }
        this.messageMapper.remove(param);
        this.redisHashMapAdapter.remove(IMRedisKey.UN_READ_MSG.copy().appendKey((Object)param.getUserId()), new String[]{String.valueOf(param.getSessionUserId())});
        this.redisHashMapAdapter.remove(IMRedisKey.LAST_MSG.copy().appendKey((Object)param.getUserId()), new String[]{String.valueOf(param.getSessionUserId())});
    }

    @Override
    public void countAndPush() {
        int monitorNum = this.imProperties.getMonitorNum();
        Date startTime = DateUtils.clearTimePart((Date)new Date());
        Date endTime = DateUtils.setField((Date)startTime, (int)11, (int)this.imProperties.getTriggerHour());
        int total = this.messageMapper.sendUserCount(startTime, endTime);
        List monitorUserIds = this.messageMapper.queryMonitorUserIds(startTime, endTime, monitorNum);
        StringBuilder content = new StringBuilder();
        content.append(DateUtils.formatDateTime((Date)endTime)).append("\u79c1\u804a\u60c5\u51b5\u6c47\u603b=======\n");
        content.append("0\u70b9\u81f3").append(this.imProperties.getTriggerHour()).append("\u53c2\u4e0e\u79c1\u804a\u4eba\u6570\uff1a[").append(total).append("]\n");
        content.append("0\u70b9\u81f3").append(this.imProperties.getTriggerHour()).append("\u53c2\u4e0e\u79c1\u804a\u6570\u91cf\u8d85\u8fc7").append(monitorNum).append("\u6b21\u4ee5\u4e0a\u7684\u7528\u6237\uff1a\n");
        if (monitorUserIds.size() > 0) {
            for (Long userId : monitorUserIds) {
                content.append("[").append(userId).append("]\n");
            }
        } else {
            content.append("[\u65e0]\n");
        }
        this.msgIntegrationService.pushIMGroup(content.toString());
    }

    @Override
    public void sendWelcomeMsg(Long userId) {
        UserBean user;
        Preconditions.checkArgument((null != userId ? 1 : 0) != 0);
        log.debug("\u65b0\u7528\u6237\u6216\u65b0\u8bbe\u5907\u9996\u6b21\u63a5\u5165\uff0c\u53d1\u9001\u6b22\u8fce\u4fe1\u606f\uff0c\u7528\u6237ID\uff1a[{}]", (Object)userId);
        String welcomeMsg = this.imProperties.getWelcomeMsg();
        if ((welcomeMsg.contains("{nickname}") || welcomeMsg.contains("{areaName}")) && null != (user = this.userIntegrationService.selectUserFromCache(userId))) {
            welcomeMsg = StringUtils.replace((String)welcomeMsg, (String)"{nickname}", (String)user.getNickname());
            if (StringUtils.isBlank((String)user.getLocationCode())) {
                welcomeMsg = StringUtils.replace((String)welcomeMsg, (String)"{areaName}", (String)"\u672c\u5730");
            } else {
                LocationDTO location = this.locationIntegrationService.getLocationByGeocode(user.getLocationCode());
                welcomeMsg = StringUtils.replace((String)welcomeMsg, (String)"{areaName}", (String)location.getName());
            }
        }
        Message message = this.sendMessage(BatchMessageParam.builder().content(welcomeMsg).fromUserId(this.imProperties.getCustomerServiceId()).toUserId((List)ImmutableList.of((Object)userId)).objectName(ObjectNameEnum.TEXT_MESSAGE.getObjectName()).build());
        message.append(this.sendMessage(BatchMessageParam.builder().content(this.imProperties.getWelcomePost()).fromUserId(this.imProperties.getCustomerServiceId()).toUserId((List)ImmutableList.of((Object)userId)).objectName(ObjectNameEnum.POST_MESSAGE.getObjectName()).build()));
        if (!message.isSuccess()) {
            log.error("\u65b0\u7528\u6237\u6b22\u8fce\u4fe1\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{},\u7528\u6237ID:{}", (Object)message.getLastMessage(), (Object)userId);
        }
    }

    @Override
    public Message sendMessage(BatchMessageParam param) {
        PrivateMessage sendParam = this.getSendParam(param);
        Message message = this.batchMessageContext.getBaseParam(param);
        if (message.isSuccess() && Objects.nonNull(message.getParam("baseParam"))) {
            BaseMessage baseMessage = (BaseMessage)message.getParam("baseParam");
            sendParam.setContent(baseMessage);
            return this.imsdkAdapter.batchSendPersonalMessage(sendParam);
        }
        return Message.build((boolean)Boolean.FALSE);
    }

    @Override
    @Async
    public void dealBatchUnReplyNum(List<IMMessageBean> msgList) {
        ArrayList dealReplyNumList = Lists.newArrayList();
        dealReplyNumList.addAll(msgList);
        Collections.sort(dealReplyNumList, Comparator.comparing(IMMessageBean::getMsgTimestamp));
        dealReplyNumList.forEach(param -> {
            Long toUserId = param.getToUserId();
            Long fromUserId = param.getFromUserId();
            UserBean toUser = this.userIntegrationService.selectUserFromCache(toUserId);
            UserBean fromUser = this.userIntegrationService.selectUserFromCache(fromUserId);
            if (StringUtils.equals((String)ChannelTypeEnum.PERSON.getTypeName(), (String)param.getChannelType())) {
                boolean formFlag;
                boolean flag;
                boolean bl = flag = Objects.nonNull(toUser) && toUser.getState() == 3;
                if (flag) {
                    KeyGenerator ruReplyUserKey = IMRedisKey.VIRTURE_USER_UNREPLY.copy().appendKey((Object)toUser.getId());
                    this.redisHashMapAdapter.increment(ruReplyUserKey, String.valueOf(param.getFromUserId()), 1);
                }
                boolean bl2 = formFlag = Objects.nonNull(fromUser) && fromUser.getState() == 3;
                if (formFlag) {
                    KeyGenerator ruReplyUserKey = IMRedisKey.VIRTURE_USER_UNREPLY.copy().appendKey((Object)fromUser.getId());
                    this.redisHashMapAdapter.remove(ruReplyUserKey, new String[]{String.valueOf(param.getToUserId())});
                }
            }
        });
    }

    private PrivateMessage getSendParam(BatchMessageParam param) {
        List<String> list = param.getToUserId().stream().map(String::valueOf).collect(Collectors.toList());
        String[] strings = new String[list.size()];
        list.toArray(strings);
        return new PrivateMessage().setSenderId(String.valueOf(param.getFromUserId())).setTargetId(strings).setObjectName(param.getObjectName()).setPushContent("").setCount("-1").setVerifyBlacklist(Integer.valueOf(1)).setIsPersisted(Integer.valueOf(1)).setIsCounted(Integer.valueOf(1)).setIsIncludeSender(Integer.valueOf(0));
    }
}

