/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.localnews.im.common.constant.IMRedisKey;
import com.bxm.localnews.im.dto.Note;
import com.bxm.localnews.im.dto.PersonMessageDTO;
import com.bxm.localnews.im.integration.ForumpostIntegration;
import com.bxm.localnews.im.integration.NoteIntegrationService;
import com.bxm.localnews.im.param.ReportReadParam;
import com.bxm.localnews.im.service.PersonMessageService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PersonMessageServiceImpl
implements PersonMessageService {
    private static final long EXPIRE_TIME = 604800L;
    private final ForumpostIntegration forumpostIntegration;
    private final NoteIntegrationService noteIntegrationService;
    private final RedisSetAdapter redisSetAdapter;

    @Override
    public PersonMessageDTO getRecentDevelopments(Long userId, Long targetUserId, Boolean needNote) {
        List<Note> noteList;
        PersonMessageDTO result = new PersonMessageDTO();
        if (null == userId || null == targetUserId) {
            return result;
        }
        if ((null == needNote || needNote.booleanValue()) && !CollectionUtils.isEmpty(noteList = this.getNoteList(userId, targetUserId))) {
            Collections.reverse(noteList);
            result.setNotes(noteList);
            return result;
        }
        PersonMessageDTO.ForumPost forumPost = this.forumpostIntegration.getRecentDevelopments(userId, targetUserId);
        result.setForumPost(forumPost);
        return result;
    }

    @Override
    public Boolean reportRead(ReportReadParam param) {
        if (null == param || null == param.getUserId() || null == param.getTargetUserId() || CollectionUtils.isEmpty((Collection)param.getContentIds()) || null == param.getReportType()) {
            return false;
        }
        if (2 == param.getReportType()) {
            KeyGenerator key = this.getUserReadNoteKey(param.getUserId(), param.getTargetUserId());
            this.redisSetAdapter.add(key, param.getContentIds().toArray());
            this.redisSetAdapter.expire(key, 604800L);
        }
        return null;
    }

    private List<Note> getNoteList(Long userId, Long targetUserId) {
        List noteList = this.noteIntegrationService.getUserNoteList(targetUserId);
        if (CollectionUtils.isEmpty((Collection)noteList)) {
            return noteList;
        }
        Set contentIds = this.redisSetAdapter.getAllMembers(this.getUserReadNoteKey(userId, targetUserId), Long.class);
        if (CollectionUtils.isEmpty((Collection)contentIds)) {
            return noteList;
        }
        ArrayList<Note> resultList = new ArrayList<Note>();
        for (Note note : noteList) {
            if (contentIds.contains(note.getId())) continue;
            resultList.add(note);
        }
        return resultList;
    }

    private KeyGenerator getUserReadNoteKey(Long userId, Long targetUserId) {
        return IMRedisKey.USER_READ_NOTE.copy().appendKey((Object)(userId + "_" + targetUserId));
    }

    @Autowired
    public PersonMessageServiceImpl(ForumpostIntegration forumpostIntegration, NoteIntegrationService noteIntegrationService, RedisSetAdapter redisSetAdapter) {
        this.forumpostIntegration = forumpostIntegration;
        this.noteIntegrationService = noteIntegrationService;
        this.redisSetAdapter = redisSetAdapter;
    }
}

