/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.localnews.im.domain.ImTimingRedPacketPlanExtendMapper;
import com.bxm.localnews.im.entry.ImTimingRedPacketPlan;
import com.bxm.localnews.im.param.ImRedPacketInfoParam;
import com.bxm.localnews.im.service.RedPacketBusinessService;
import com.bxm.localnews.im.service.TimingRedPacketPlanService;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TimingRedPacketPlanServiceImpl
implements TimingRedPacketPlanService {
    private static final Logger log = LoggerFactory.getLogger(TimingRedPacketPlanServiceImpl.class);
    @Autowired
    private ImTimingRedPacketPlanExtendMapper imTimingRedPacketPlanExtendMapper;
    @Autowired
    private RedPacketBusinessService redPacketBusinessService;

    @Override
    public Message createRedPacketFromPlan(Long timingRedPacketPlanId) {
        if (Objects.isNull(timingRedPacketPlanId)) {
            return Message.build((boolean)false).setMessage("\u5b9a\u65f6\u7ea2\u5305\u8ba1\u5212id\u4e3a\u7a7a");
        }
        ImTimingRedPacketPlan plan = this.imTimingRedPacketPlanExtendMapper.selectByPrimaryKey(timingRedPacketPlanId);
        if (Objects.isNull(plan)) {
            return Message.build((boolean)false).setMessage("\u5b9a\u65f6\u7ea2\u5305\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        return this.redPacketBusinessService.createAndSent(ImRedPacketInfoParam.builder().amountType(plan.getRedPacketAmountType()).authType(plan.getRedPacketAuthType()).name(plan.getRedPacketName()).redPacketDistributeArithmeticType(plan.getRedPacketDistributeArithmeticType()).remark(plan.getRedPacketRemark()).source(plan.getRedPacketSource()).sourceUserId(plan.getRedPacketSourceUserId()).targetId(plan.getRedPacketTargetId()).timingRedPacketPlanId(plan.getId()).totalAmount(plan.getRedPacketTotalAmount()).type(plan.getRedPacketType()).totalNum(plan.getRedPacketTotalNum()).build());
    }

    @Override
    public ImTimingRedPacketPlan getChatRoomNearestTimingRedPacketPlan(String charRoomId) {
        List imTimingRedPacketPlans = this.imTimingRedPacketPlanExtendMapper.listByChatRoomId(charRoomId);
        if (!CollectionUtils.isEmpty((Collection)imTimingRedPacketPlans)) {
            LocalDateTime assignTimePlanTime;
            Optional imTimingRedPacketPlanOptional;
            HashMap map = Maps.newHashMap();
            imTimingRedPacketPlans.forEach(p -> {
                List plans = (List)map.get(p.getTimingType());
                if (CollectionUtils.isEmpty((Collection)plans)) {
                    plans = Lists.newArrayList();
                    map.put(p.getTimingType(), plans);
                }
                plans.add(p);
            });
            List assignTimeList = (List)map.get((byte)2);
            ImTimingRedPacketPlan assignTimePlan = null;
            ZoneId zone = ZoneId.systemDefault();
            if (!CollectionUtils.isEmpty((Collection)assignTimeList) && (imTimingRedPacketPlanOptional = assignTimeList.stream().sorted((p1, p2) -> {
                if (Objects.isNull(p1.getSentDate()) && Objects.isNull(p2.getSentDate())) {
                    return 0;
                }
                if (Objects.isNull(p1.getSentDate())) {
                    return -1;
                }
                if (Objects.isNull(p2.getSentDate())) {
                    return 1;
                }
                LocalDateTime localDateTime1 = LocalDateTime.ofInstant(p1.getSentDate().toInstant(), zone);
                LocalDateTime localDateTime2 = LocalDateTime.ofInstant(p2.getSentDate().toInstant(), zone);
                return localDateTime1.compareTo(localDateTime2);
            }).findFirst()).isPresent()) {
                assignTimePlan = (ImTimingRedPacketPlan)imTimingRedPacketPlanOptional.get();
            }
            List evertDayList = (List)map.get((byte)1);
            ImTimingRedPacketPlan evertDayPlan = null;
            LocalTime localTimeNow = LocalTime.now();
            if (!CollectionUtils.isEmpty((Collection)evertDayList)) {
                List evertDayListSorted = evertDayList.stream().sorted((p1, p2) -> {
                    if (Objects.isNull(p1.getSentTime()) && Objects.isNull(p2.getSentTime())) {
                        return 0;
                    }
                    if (Objects.isNull(p1.getSentTime())) {
                        return -1;
                    }
                    if (Objects.isNull(p2.getSentTime())) {
                        return 1;
                    }
                    LocalTime localTime1 = LocalDateTime.ofInstant(p1.getSentTime().toInstant(), zone).toLocalTime();
                    LocalTime localTime2 = LocalDateTime.ofInstant(p2.getSentTime().toInstant(), zone).toLocalTime();
                    return localTime1.compareTo(localTime2);
                }).collect(Collectors.toList());
                Optional<Object> imTimingRedPacketPlanOptional2 = evertDayListSorted.stream().filter(p -> {
                    LocalTime localTime = LocalDateTime.ofInstant(p.getSentTime().toInstant(), zone).toLocalTime();
                    return !localTime.isBefore(localTimeNow);
                }).findFirst();
                if (imTimingRedPacketPlanOptional2.isPresent()) {
                    evertDayPlan = imTimingRedPacketPlanOptional2.get();
                } else {
                    imTimingRedPacketPlanOptional2 = evertDayListSorted.stream().findFirst();
                    if (imTimingRedPacketPlanOptional2.isPresent()) {
                        evertDayPlan = (ImTimingRedPacketPlan)imTimingRedPacketPlanOptional2.get();
                    }
                }
            }
            if (Objects.isNull(evertDayPlan)) {
                return assignTimePlan;
            }
            if (Objects.isNull(assignTimePlan)) {
                return evertDayPlan;
            }
            LocalDateTime evertDayPlanTime = LocalDateTime.of(LocalDate.now(), LocalDateTime.ofInstant(evertDayPlan.getSentTime().toInstant(), zone).toLocalTime());
            return evertDayPlanTime.compareTo(assignTimePlanTime = LocalDateTime.ofInstant(assignTimePlan.getSentDate().toInstant(), zone)) > 0 ? evertDayPlan : assignTimePlan;
        }
        return null;
    }
}

