/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl.redpacket.cache.impl;

import com.bxm.localnews.im.constant.RedPacketRedisCons;
import com.bxm.localnews.im.domain.ImRedPacketMapper;
import com.bxm.localnews.im.dto.ImRedPacketInfo;
import com.bxm.localnews.im.en.RedPacketAction;
import com.bxm.localnews.im.entry.ImRedPacket;
import com.bxm.localnews.im.param.ImRedPacketInfoCacheParam;
import com.bxm.localnews.im.param.RedPacketCacheClearParam;
import com.bxm.localnews.im.service.impl.redpacket.cache.AbstractRedPacketCache;
import com.bxm.localnews.im.service.impl.redpacket.cache.annotation.RedPacketCacheAnno;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RedPacketCacheAnno(param=ImRedPacketInfoCacheParam.class, actions={RedPacketAction.OPEN_RED_PACKET_FINISHED})
public class ImRedPacketInfoCache
extends AbstractRedPacketCache<ImRedPacketInfo, ImRedPacketInfoCacheParam> {
    @Autowired
    private ImRedPacketMapper imRedPacketMapper;

    @Override
    protected ImRedPacketInfo doLoadCache(ImRedPacketInfoCacheParam param) {
        if (Objects.isNull(param.getRedPacketId())) {
            return ImRedPacketInfo.builder().build();
        }
        String redPacketIdStr = Objects.toString(param.getRedPacketId());
        ImRedPacketInfo redPacketInfo = (ImRedPacketInfo)this.redisHashMapAdapter.get(RedPacketRedisCons.RED_PACKET_INFO, redPacketIdStr, ImRedPacketInfo.class);
        if (Objects.isNull(redPacketInfo)) {
            ImRedPacket redPacket = this.imRedPacketMapper.selectByPrimaryKey(param.getRedPacketId());
            redPacketInfo = this.convert(redPacket);
            this.redisHashMapAdapter.put(RedPacketRedisCons.RED_PACKET_INFO, redPacketIdStr, (Object)redPacketInfo);
        }
        return redPacketInfo;
    }

    @Override
    protected void doClear(RedPacketCacheClearParam param) {
        if (Objects.isNull(param.getRedPacketId())) {
            this.log.warn("\u7ea2\u5305id\u4e3anull\uff0c\u65e0\u6cd5\u6e05\u9664\u7f13\u5b58");
            return;
        }
        this.redisHashMapAdapter.remove(RedPacketRedisCons.RED_PACKET_INFO, new String[]{Objects.toString(param.getRedPacketId())});
    }

    private ImRedPacketInfo convert(ImRedPacket redPacket) {
        ImRedPacketInfo info = ImRedPacketInfo.builder().build();
        if (Objects.nonNull(redPacket)) {
            BeanUtils.copyProperties((Object)redPacket, (Object)info);
        }
        return info;
    }
}

