/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl.redpacket.cache.impl;

import com.bxm.localnews.im.constant.RedPacketRedisCons;
import com.bxm.localnews.im.domain.ImChatroomMapper;
import com.bxm.localnews.im.domain.ImTimingRedPacketPlanExtendMapper;
import com.bxm.localnews.im.dto.ImRedPacketInfo;
import com.bxm.localnews.im.dto.RedPackageDto;
import com.bxm.localnews.im.en.RedPacketAction;
import com.bxm.localnews.im.entry.ImTimingRedPacketPlan;
import com.bxm.localnews.im.param.ChatRoomNearestTimingRedPacketPlanInfoParam;
import com.bxm.localnews.im.param.ImRedPacketInfoCacheParam;
import com.bxm.localnews.im.param.RedPacketCacheClearParam;
import com.bxm.localnews.im.service.impl.redpacket.cache.AbstractRedPacketCache;
import com.bxm.localnews.im.service.impl.redpacket.cache.annotation.RedPacketCacheAnno;
import com.bxm.localnews.im.vo.ImChatroom;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import java.text.DateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

@RedPacketCacheAnno(param=ChatRoomNearestTimingRedPacketPlanInfoParam.class, actions={RedPacketAction.CREATE_PLAN, RedPacketAction.CREATE_RED_PACKET})
public class RedPackageDtoCache
extends AbstractRedPacketCache<RedPackageDto, ChatRoomNearestTimingRedPacketPlanInfoParam> {
    @Autowired
    private ImTimingRedPacketPlanExtendMapper imTimingRedPacketPlanExtendMapper;
    @Autowired
    private ImChatroomMapper imChatroomMapper;

    @Override
    protected RedPackageDto doLoadCache(ChatRoomNearestTimingRedPacketPlanInfoParam param) {
        ImChatroom chatroom = this.imChatroomMapper.selectByChatRoomId(param.getChatRoomId());
        if (Objects.isNull(chatroom) || Objects.isNull(chatroom.getEnableChatRoom()) || Objects.equals(chatroom.getEnableChatRoom().intValue(), 0) || Objects.isNull(chatroom.getEnableTimingRedPacket()) || Objects.equals(chatroom.getEnableTimingRedPacket().intValue(), 0)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u804a\u5929\u5ba4\u5173\u95ed or \u7ea2\u5305\u5173\u95ed");
            }
            return RedPackageDto.builder().build();
        }
        KeyGenerator key = RedPacketRedisCons.CHAT_ROOM_NEAREST_RED_PACKET_PLAN_INFO.copy().appendKey((Object)Objects.toString(param.getChatRoomId()));
        RedPackageDto packageDto = (RedPackageDto)this.redisStringAdapter.get(key, RedPackageDto.class);
        if (Objects.isNull(packageDto)) {
            ImTimingRedPacketPlan timingRedPacketPlan = this.timingRedPacketPlanService.getChatRoomNearestTimingRedPacketPlan(param.getChatRoomId());
            long expireTime = 300L;
            if (Objects.nonNull(timingRedPacketPlan)) {
                String dayStr = "";
                String timeStr = "";
                LocalDateTime openTime = LocalDateTime.now();
                LocalDateTime now = LocalDateTime.now();
                if (Objects.equals(timingRedPacketPlan.getTimingType(), (byte)2)) {
                    dayStr = DateUtils.getDayLag((Date)timingRedPacketPlan.getSentDate());
                    timeStr = ((DateFormat)DateUtils.PATTERN_HOUR_MINUTE_FORMAT.get()).format(timingRedPacketPlan.getSentDate());
                    openTime = LocalDateTime.ofInstant(timingRedPacketPlan.getSentDate().toInstant(), ZoneId.systemDefault());
                }
                if (Objects.equals(timingRedPacketPlan.getTimingType(), (byte)1)) {
                    timeStr = ((DateFormat)DateUtils.PATTERN_HOUR_MINUTE_FORMAT.get()).format(timingRedPacketPlan.getSentTime());
                    openTime = LocalDateTime.of(LocalDate.now(), LocalDateTime.ofInstant(timingRedPacketPlan.getSentTime().toInstant(), ZoneId.systemDefault()).toLocalTime());
                    dayStr = (openTime = LocalDateTime.of(openTime.getYear(), openTime.getMonth(), openTime.getDayOfMonth(), openTime.getHour(), openTime.getMinute(), 0, 0)).isBefore(now) ? "\u660e\u5929" : "\u4eca\u5929";
                }
                Instant instant = openTime.atZone(ZoneId.systemDefault()).toInstant();
                packageDto = RedPackageDto.builder().content("\u51c6\u65f6\u5f00\u62a2").dayStr(dayStr).timeStr(timeStr).startTime(Date.from(instant)).title("\u5b9a\u65f6\u7ea2\u5305").timingRedPacketPlanId(timingRedPacketPlan.getId()).build();
                long toDayEndMillis = DateUtils.getTodayEndMillis() / 1000L - 10L;
                expireTime = openTime.isBefore(now) || now.plusSeconds(toDayEndMillis).isBefore(openTime) ? toDayEndMillis : openTime.toEpochSecond(ZoneOffset.of("+8")) - System.currentTimeMillis() / 1000L;
            } else {
                packageDto = RedPackageDto.builder().build();
            }
            this.redisStringAdapter.set(key, (Object)packageDto, expireTime);
        }
        if (Objects.nonNull(packageDto) && Objects.nonNull(packageDto.getTimingRedPacketPlanId()) && Objects.nonNull(param.getUserId())) {
            packageDto.setEnableNotify(Boolean.valueOf(this.redPacketReminderService.hasReminded(param.getUserId(), packageDto.getTimingRedPacketPlanId())));
        }
        return packageDto;
    }

    @Override
    protected void doClear(RedPacketCacheClearParam param) {
        KeyGenerator key = null;
        if (Objects.equals(param.getAction(), RedPacketAction.CREATE_PLAN)) {
            if (Objects.isNull(param.getTimingRedPacketPlanId())) {
                this.log.warn("\u5b9a\u65f6\u8ba1\u5212id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6e05\u9664\u804a\u5929\u5ba4\u6700\u8fd1\u7ea2\u5305\u7f13\u5b58");
                return;
            }
            ImTimingRedPacketPlan imTimingRedPacketPlan = this.imTimingRedPacketPlanExtendMapper.selectByPrimaryKey(param.getTimingRedPacketPlanId());
            if (Objects.nonNull(imTimingRedPacketPlan)) {
                key = RedPacketRedisCons.CHAT_ROOM_NEAREST_RED_PACKET_PLAN_INFO.copy().appendKey((Object)Objects.toString(imTimingRedPacketPlan.getRedPacketTargetId()));
            }
        } else if (Objects.equals(param.getAction(), RedPacketAction.CREATE_RED_PACKET)) {
            if (Objects.isNull(param.getRedPacketId())) {
                this.log.warn("\u7ea2\u5305id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6e05\u9664\u804a\u5929\u5ba4\u6700\u8fd1\u7ea2\u5305\u7f13\u5b58");
                return;
            }
            ImRedPacketInfo redPacketInfo = (ImRedPacketInfo)this.redPacketCacheProxyService.loadCache(ImRedPacketInfoCacheParam.builder().redPacketId(param.getRedPacketId()).build());
            if (Objects.nonNull(redPacketInfo)) {
                key = RedPacketRedisCons.CHAT_ROOM_NEAREST_RED_PACKET_PLAN_INFO.copy().appendKey((Object)Objects.toString(redPacketInfo.getTargetId()));
            }
        }
        if (Objects.nonNull(key)) {
            this.redisStringAdapter.remove(key);
        }
    }
}

