/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl.redpacket.strategy;

import com.bxm.localnews.im.bo.DistributePlan;
import com.bxm.localnews.im.en.RedPacketDistributeArithmeticTypeEn;
import com.bxm.localnews.im.service.impl.redpacket.strategy.AbstractDistributeArithmeticStrategy;
import com.bxm.newidea.component.tools.RandomUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MaxDoubleAverStrategy
extends AbstractDistributeArithmeticStrategy {
    private static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(2L);

    @Override
    protected List<DistributePlan> doCreatePlan(BigDecimal totalAmt, BigDecimal totalNum, BigDecimal average) {
        BigDecimal amt;
        int i;
        totalAmt = totalAmt.multiply(ONE_HUNDRED);
        BigDecimal maxAmt = average.setScale(2, RoundingMode.DOWN).multiply(MAX_DOUBLE).multiply(ONE_HUNDRED);
        BigDecimal mix = MIX_AMT_INT;
        ArrayList<DistributePlan> plans = new ArrayList<DistributePlan>(totalNum.intValue());
        BigDecimal lastOverAmt = BigDecimal.ZERO;
        BigDecimal rest = totalAmt;
        for (i = 1; i <= totalNum.intValue(); ++i) {
            BigDecimal restNum = totalNum.subtract(BigDecimal.valueOf(i));
            if (i == totalNum.intValue()) {
                amt = rest;
                if (amt.compareTo(maxAmt) > 0) {
                    lastOverAmt = amt.subtract(maxAmt);
                    amt = maxAmt;
                }
            } else {
                BigDecimal end = rest.subtract(restNum.multiply(mix));
                if (end.compareTo(maxAmt) > 0) {
                    end = maxAmt;
                }
                if ((amt = BigDecimal.valueOf(RandomUtils.nextInt((int)mix.intValue(), (int)end.intValue()))).compareTo(maxAmt) > 0) {
                    amt = maxAmt;
                }
            }
            rest = rest.subtract(amt);
            amt = amt.divide(ONE_HUNDRED, 2, RoundingMode.HALF_DOWN);
            plans.add(this.build(amt, i));
        }
        i = 0;
        while (lastOverAmt.compareTo(BigDecimal.ZERO) > 0) {
            DistributePlan plan = (DistributePlan)plans.get(i);
            amt = plan.getRedPacketAmount().multiply(ONE_HUNDRED).add(lastOverAmt);
            if (amt.compareTo(maxAmt) > 0) {
                plan.setRedPacketAmount(maxAmt.divide(ONE_HUNDRED, 2, RoundingMode.HALF_DOWN));
                lastOverAmt = amt.subtract(maxAmt);
            } else {
                plan.setRedPacketAmount(amt.divide(ONE_HUNDRED, 2, RoundingMode.HALF_DOWN));
                lastOverAmt = BigDecimal.ZERO;
            }
            ++i;
        }
        return plans;
    }

    @Override
    public RedPacketDistributeArithmeticTypeEn support() {
        return RedPacketDistributeArithmeticTypeEn.MAX_DOUBLE_AVER;
    }
}

