/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.task;

import com.bxm.localnews.im.domain.MessageMapper;
import com.bxm.localnews.im.entry.VirtualUserBean;
import com.bxm.localnews.im.integration.MsgIntegrationService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DingDingCronTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(DingDingCronTask.class);
    private final MsgIntegrationService msgIntegrationService;
    private final MessageMapper messageMapper;
    private static final int INTERVAL = -1;

    @Autowired
    public DingDingCronTask(MsgIntegrationService msgIntegrationService, MessageMapper messageMapper) {
        this.msgIntegrationService = msgIntegrationService;
        this.messageMapper = messageMapper;
    }

    protected ReturnT<String> service(String param) {
        Date endTime = DateUtils.addField((Date)new Date(), (int)12, (int)-1);
        List virtualUserBeans = this.messageMapper.queryVirtualRecive(endTime);
        if (log.isDebugEnabled()) {
            log.debug("\u89e6\u53d1\u9489\u9489\u63a8\u9001\uff0c\u6709{}\u4e2a\u7528\u6237\u7ed9\u9a6c\u7532\u53f7\u53d1\u9001\u4e86\u79c1\u804a", (Object)virtualUserBeans.size());
        }
        if (!CollectionUtils.isEmpty((Collection)virtualUserBeans)) {
            StringBuilder content = new StringBuilder();
            content.append(DateUtils.formatDateTime((Date)endTime)).append("\u6536\u5230\u7528\u6237\u79c1\u804a==========\n");
            for (VirtualUserBean virtualUser : virtualUserBeans) {
                content.append(virtualUser.getNickName()).append("(").append(virtualUser.getUserId()).append(")\n");
            }
            this.msgIntegrationService.pushIMGroup(content.toString());
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "VirtualAccountTalkDingDingPush";
    }

    public String cron() {
        return "0 0/1 * * * ?";
    }

    public String description() {
        return "\u5b9a\u65f6\u7ed9\u8fd0\u8425\u63d0\u4f9b\u9a6c\u7532\u53f7\u63a5\u6536\u79c1\u804a\u4fe1\u606f\u60c5\u51b5";
    }
}

