/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.batchmessage;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.im.batchmessage.strategy.AbstractBaseParamStrategy;
import com.bxm.localnews.im.batchmessage.strategy.TextMessageStrategy;
import com.bxm.localnews.im.enums.ObjectNameEnum;
import com.bxm.localnews.im.param.BatchMessageParam;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import io.rong.messages.BaseMessage;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class BatchMessageContext
implements ApplicationRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(BatchMessageContext.class);
    private ApplicationContext applicationContext;
    public static final String BASE_PARAM_KEY = "baseParam";
    private static final Map<ObjectNameEnum, AbstractBaseParamStrategy> config = Maps.newHashMap();

    public Message getBaseParam(BatchMessageParam param) {
        ObjectNameEnum sendEnum = ObjectNameEnum.getSendEnum(param.getObjectName());
        AbstractBaseParamStrategy messageStrategy = Objects.isNull((Object)sendEnum) ? (AbstractBaseParamStrategy)SpringContextHolder.getBean(TextMessageStrategy.class) : config.get((Object)sendEnum);
        Message message = messageStrategy.checkParam(param);
        if (!message.isSuccess()) {
            log.debug("\u53c2\u6570\u6821\u9a8c\u7ed3\u679c,result=[{}]", (Object)JSONObject.toJSONString((Object)message));
            return message;
        }
        BaseMessage baseMessage = messageStrategy.assemblyParam(param);
        message.addParam(BASE_PARAM_KEY, (Object)baseMessage);
        return message;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void run(ApplicationArguments args) throws Exception {
        Map beansOfType = this.applicationContext.getBeansOfType(AbstractBaseParamStrategy.class);
        Collection values = beansOfType.values();
        values.forEach(strategy -> config.put(strategy.support(), (AbstractBaseParamStrategy)strategy));
    }
}

