/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.im.bo.OpenRedPackageActionParam;
import com.bxm.localnews.im.dto.ImRedPacketInfo;
import com.bxm.localnews.im.dto.RedPackageDetailDto;
import com.bxm.localnews.im.dto.RedPackageDto;
import com.bxm.localnews.im.dto.RedPackageStatusDto;
import com.bxm.localnews.im.en.RedPacketTypeEn;
import com.bxm.localnews.im.param.ChatRoomNearestTimingRedPacketPlanInfoParam;
import com.bxm.localnews.im.param.ImRedPacketCreateParam;
import com.bxm.localnews.im.param.ImRedPacketInfoParam;
import com.bxm.localnews.im.param.OpenRedPackageParam;
import com.bxm.localnews.im.param.RedPackageDetailParam;
import com.bxm.localnews.im.param.RedPackageStatusParam;
import com.bxm.localnews.im.service.RedPacketBusinessService;
import com.bxm.localnews.im.service.RedPacketInfoService;
import com.bxm.localnews.im.service.impl.RedPacketCacheProxyService;
import com.bxm.localnews.im.service.impl.redpacket.RedPacketService;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class RedPacketBusinessServiceImpl
implements RedPacketBusinessService,
ApplicationContextAware,
ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(RedPacketBusinessServiceImpl.class);
    private ApplicationContext applicationContext;
    private static final Map<RedPacketTypeEn, RedPacketService> RED_PACKET_ACTION_SERVICE_MAP = Maps.newHashMap();
    @Autowired
    private RedPacketInfoService redPacketInfoService;
    @Autowired
    private RedPacketCacheProxyService redPacketCacheProxyService;

    @Override
    public Message createAndSent(ImRedPacketInfoParam param) {
        if (Objects.isNull(param)) {
            log.warn("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a: [{}]", (Object)param);
            return Message.build((boolean)false).setMessage("\u521b\u5efa\u7ea2\u5305\u5931\u8d25");
        }
        RedPacketService redPacketActionService = this.getByType(param.getType());
        if (Objects.nonNull(redPacketActionService)) {
            return redPacketActionService.create(ImRedPacketCreateParam.builder().redPacketInfoParam(param).sentImmediately(Boolean.TRUE).build());
        }
        return Message.build((boolean)false).setMessage("\u521b\u5efa\u7ea2\u5305\u5931\u8d25");
    }

    @Override
    public RedPackageDetailDto openAndGetInfoIfSuccess(OpenRedPackageParam param) {
        RedPacketService redPacketActionService;
        if (Objects.isNull(param) || Objects.isNull(param.getUserId()) || Objects.isNull(param.getRedPackageId())) {
            log.warn("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a: [{}]", (Object)param);
            return RedPackageDetailDto.builder().build();
        }
        ImRedPacketInfo redPacketInfo = this.redPacketInfoService.loadCache(param.getRedPackageId());
        if (Objects.nonNull(redPacketInfo) && Objects.nonNull(redPacketActionService = this.getByType(redPacketInfo.getType()))) {
            return redPacketActionService.openAndGetInfoIfSuccess(OpenRedPackageActionParam.builder().userId(param.getUserId()).redPacketInfo(redPacketInfo).basicParam((BasicParam)param).areaCode(param.getAreaCode()).build());
        }
        return RedPackageDetailDto.builder().build();
    }

    @Override
    public RedPackageDto chatRoomNearestTimingRedPacketPlanInfo(ChatRoomNearestTimingRedPacketPlanInfoParam param) {
        return (RedPackageDto)this.redPacketCacheProxyService.loadCache(param);
    }

    @Override
    public RedPackageStatusDto redPackageStatus(RedPackageStatusParam param) {
        return (RedPackageStatusDto)this.redPacketCacheProxyService.loadCache(param);
    }

    @Override
    public RedPackageDetailDto redPackageDetail(RedPackageDetailParam param) {
        return (RedPackageDetailDto)this.redPacketCacheProxyService.loadCache(param);
    }

    private RedPacketService getByType(Byte type) {
        RedPacketTypeEn redPacketTypeEn = RedPacketTypeEn.getByType((Byte)type);
        RedPacketService redPacketActionService = RED_PACKET_ACTION_SERVICE_MAP.get(redPacketTypeEn);
        if (Objects.isNull(redPacketActionService)) {
            log.warn("\u7c7b\u578b: [{}] \u6ca1\u6709\u5904\u7406\u7c7b", (Object)type);
        }
        return redPacketActionService;
    }

    public void run(ApplicationArguments args) throws Exception {
        Collection redPacketServices = this.applicationContext.getBeansOfType(RedPacketService.class).values();
        redPacketServices.forEach(p -> {
            if (Objects.nonNull(p.support())) {
                RED_PACKET_ACTION_SERVICE_MAP.put(p.support(), (RedPacketService)p);
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

