/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.localnews.im.en.RedPacketAction;
import com.bxm.localnews.im.param.RedPacketCacheClearParam;
import com.bxm.localnews.im.service.impl.redpacket.cache.RedPacketCache;
import com.bxm.localnews.im.service.impl.redpacket.cache.RedPacketCacheClearListener;
import com.bxm.localnews.im.service.impl.redpacket.cache.annotation.RedPacketCacheAnno;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RedPacketCacheProxyService
implements ApplicationContextAware,
ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(RedPacketCacheProxyService.class);
    private final Map<Class<?>, RedPacketCache> redPacketCacheMap = Maps.newHashMap();
    private final Map<RedPacketAction, List<RedPacketCacheClearListener>> listenerMaps = Maps.newHashMap();
    private ApplicationContext applicationContext;

    public <R, P> R loadCache(P param) {
        if (Objects.isNull(param)) {
            return null;
        }
        RedPacketCache redPacketCache = this.redPacketCacheMap.get(param.getClass());
        if (Objects.nonNull(redPacketCache)) {
            Object r = redPacketCache.loadCache(param);
            return r == null ? null : (R)r;
        }
        return null;
    }

    public void publish(RedPacketCacheClearParam param) {
        if (Objects.isNull(param) || Objects.isNull(param.getAction())) {
            log.warn("\u53d1\u5e03\u4e8b\u4ef6\u53c2\u6570\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u5e03");
            return;
        }
        List<RedPacketCacheClearListener> listeners = this.listenerMaps.get(param.getAction());
        if (!CollectionUtils.isEmpty(listeners)) {
            listeners.forEach(p -> p.clear(param));
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        Collection redPacketCaches = this.applicationContext.getBeansOfType(RedPacketCache.class).values();
        redPacketCaches.forEach(p -> {
            RedPacketCacheAnno redPacketCacheAnno = (RedPacketCacheAnno)AnnotationUtils.getAnnotation((AnnotatedElement)AopUtils.getTargetClass((Object)p), RedPacketCacheAnno.class);
            if (Objects.nonNull(redPacketCacheAnno)) {
                Class<?> clazz = redPacketCacheAnno.param();
                if (Objects.nonNull(clazz)) {
                    this.redPacketCacheMap.put(clazz, (RedPacketCache)p);
                }
                RedPacketAction[] redPacketActions = redPacketCacheAnno.actions();
                Arrays.asList(redPacketActions).forEach(p1 -> {
                    ArrayList redPacketCaches1 = this.listenerMaps.get(p1);
                    if (Objects.isNull(redPacketCaches1)) {
                        redPacketCaches1 = Lists.newArrayList();
                        this.listenerMaps.put((RedPacketAction)p1, redPacketCaches1);
                    }
                    redPacketCaches1.add((RedPacketCacheClearListener)((Object)p));
                });
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

