/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.localnews.im.domain.ImTimingRedPacketPlanMapper;
import com.bxm.localnews.im.en.ChatRoomRedPacketNoticeType;
import com.bxm.localnews.im.en.RedPacketAction;
import com.bxm.localnews.im.entry.ImTimingRedPacketPlan;
import com.bxm.localnews.im.param.CreateRedPacketTaskFacadeParam;
import com.bxm.localnews.im.param.CreateRedPacketTaskParam;
import com.bxm.localnews.im.param.RedPacketCacheClearParam;
import com.bxm.localnews.im.param.RedPacketRemindTaskParam;
import com.bxm.localnews.im.param.RemoveRedPacketTaskParam;
import com.bxm.localnews.im.param.SentNoticeToChatRoomParam;
import com.bxm.localnews.im.service.RedPacketFacadeService;
import com.bxm.localnews.im.service.impl.RedPacketCacheProxyService;
import com.bxm.localnews.im.task.CreateRedPacketCallback;
import com.bxm.localnews.im.task.RedPacketNoticeMsgCallback;
import com.bxm.localnews.im.task.RedPacketRemindCallback;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.builder.CronTaskBuilder;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.vo.Message;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedPacketFacadeServiceImpl
implements RedPacketFacadeService {
    private static final Logger log = LoggerFactory.getLogger(RedPacketFacadeServiceImpl.class);
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private CreateRedPacketCallback createRedPacketCallback;
    @Autowired
    private RedPacketRemindCallback redPacketRemindCallback;
    @Autowired
    private RedPacketNoticeMsgCallback redPacketNoticeMsgCallback;
    @Autowired
    private ImTimingRedPacketPlanMapper imTimingRedPacketPlanMapper;
    @Autowired
    private RedPacketCacheProxyService redPacketCacheProxyService;

    @Override
    public Message createRedPacketTask(CreateRedPacketTaskFacadeParam facadeParam) {
        ImTimingRedPacketPlan plan;
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u7ea2\u5305\u76f8\u5173\u5b9a\u65f6\u4efb\u52a1, \u8bf7\u6c42\u53c2\u6570: {}", (Object)facadeParam);
        }
        if (Objects.isNull(plan = this.imTimingRedPacketPlanMapper.selectByPrimaryKey(facadeParam.getTimingRedPacketPlanId()))) {
            return Message.build((boolean)false).setMessage("\u5b9a\u65f6\u7ea2\u5305\u4e0d\u5b58\u5728");
        }
        try {
            this.createRedPacketTask(plan);
            this.redPacketRemindTask(plan);
            this.redPacketNoticeMsgTask(plan);
            this.redPacketCacheProxyService.publish(RedPacketCacheClearParam.builder().action(RedPacketAction.CREATE_PLAN).timingRedPacketPlanId(facadeParam.getTimingRedPacketPlanId()).build());
            return Message.build();
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5b9a\u65f6\u7ea2\u5305\u76f8\u5173\u7684\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25!!", (Throwable)e);
            return Message.build((boolean)false);
        }
    }

    @Override
    public Message removeRedPacketTask(RemoveRedPacketTaskParam facadeParam) {
        ImTimingRedPacketPlan plan;
        if (log.isDebugEnabled()) {
            log.debug("\u79fb\u9664\u7ea2\u5305\u76f8\u5173\u5b9a\u65f6\u4efb\u52a1, \u8bf7\u6c42\u53c2\u6570: {}", (Object)facadeParam);
        }
        if (Objects.isNull(plan = this.imTimingRedPacketPlanMapper.selectByPrimaryKey(facadeParam.getTimingRedPacketPlanId()))) {
            return Message.build((boolean)false).setMessage("\u5b9a\u65f6\u7ea2\u5305\u4e0d\u5b58\u5728");
        }
        try {
            List<String> taskNames = Arrays.asList(StringUtils.join((Object[])new Serializable[]{"RedPacketNoticeMsgTask_", Byte.valueOf(ChatRoomRedPacketNoticeType.A.getType()), "_", plan.getId()}), StringUtils.join((Object[])new Serializable[]{"RedPacketNoticeMsgTask_", Byte.valueOf(ChatRoomRedPacketNoticeType.B.getType()), "_", plan.getId()}), StringUtils.join((Object[])new Serializable[]{"RedPacketNoticeMsgTask_", Byte.valueOf(ChatRoomRedPacketNoticeType.C.getType()), "_", plan.getId()}), StringUtils.join((Object[])new Serializable[]{"RedPacketNoticeMsgTask_", Byte.valueOf(ChatRoomRedPacketNoticeType.D.getType()), "_", plan.getId()}), StringUtils.join((Object[])new Serializable[]{"RedPacketRemindTask_", plan.getId()}), StringUtils.join((Object[])new Serializable[]{"CreateRedPacketTask_", plan.getId()}));
            taskNames.forEach(p -> this.scheduleService.remove(p));
            return Message.build();
        }
        catch (Exception e) {
            log.error("\u79fb\u9664\u5b9a\u65f6\u7ea2\u5305\u76f8\u5173\u7684\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25!!", (Throwable)e);
            return Message.build((boolean)false);
        }
    }

    private Message createRedPacketTask(ImTimingRedPacketPlan plan) {
        CreateRedPacketTaskParam param = new CreateRedPacketTaskParam();
        param.setTimingRedPacketPlanId(plan.getId());
        Calendar instance = Calendar.getInstance();
        instance.setTime(plan.getSentTime());
        String taskName = StringUtils.join((Object[])new Serializable[]{"CreateRedPacketTask_", param.getTimingRedPacketPlanId()});
        this.scheduleService.remove(taskName);
        this.scheduleService.push((ScheduleTask)CronTaskBuilder.builder((String)taskName, (String)StringUtils.join((Object[])new Serializable[]{"0 ", Integer.valueOf(instance.get(12)), " ", Integer.valueOf(instance.get(11)), " * * ?"}), (TaskCallback)this.createRedPacketCallback).callbackParam((Object)param).description(StringUtils.join((Object[])new Serializable[]{"id: ", plan.getId(), " \u521b\u5efa\u5b9a\u65f6\u7ea2\u5305"})).build());
        return Message.build();
    }

    private Message redPacketNoticeMsgTask(ImTimingRedPacketPlan plan) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(plan.getSentTime());
        instance.add(13, -10);
        String taskName = StringUtils.join((Object[])new Serializable[]{"RedPacketNoticeMsgTask_", Byte.valueOf(ChatRoomRedPacketNoticeType.C.getType()), "_", plan.getId()});
        this.scheduleService.remove(taskName);
        SentNoticeToChatRoomParam param = new SentNoticeToChatRoomParam();
        param.setTimingRedPacketPlanId(plan.getId());
        param.setNoticeType(Byte.valueOf(ChatRoomRedPacketNoticeType.C.getType()));
        instance.add(13, -50);
        taskName = StringUtils.join((Object[])new Serializable[]{"RedPacketNoticeMsgTask_", Byte.valueOf(ChatRoomRedPacketNoticeType.B.getType()), "_", plan.getId()});
        this.scheduleService.remove(taskName);
        param = new SentNoticeToChatRoomParam();
        param.setTimingRedPacketPlanId(plan.getId());
        param.setNoticeType(Byte.valueOf(ChatRoomRedPacketNoticeType.B.getType()));
        this.scheduleService.push((ScheduleTask)CronTaskBuilder.builder((String)taskName, (String)StringUtils.join((Object[])new Serializable[]{Integer.valueOf(instance.get(13)), " ", Integer.valueOf(instance.get(12)), " ", Integer.valueOf(instance.get(11)), " * * ?"}), (TaskCallback)this.redPacketNoticeMsgCallback).callbackParam((Object)param).description(StringUtils.join((Object[])new Serializable[]{"id: ", plan.getId(), " \u7ea2\u5305\u53d1\u653e\u524d60s \u5b9a\u65f6\u7ea2\u5305\u8fd8\u670960\u79d2\u5230\u8fbe\uff0c\u51c6\u5907\u597d\u5f00\u62a2\u4e86\u5417"})).build());
        instance.add(13, -60);
        taskName = StringUtils.join((Object[])new Serializable[]{"RedPacketNoticeMsgTask_", Byte.valueOf(ChatRoomRedPacketNoticeType.A.getType()), "_", plan.getId()});
        this.scheduleService.remove(taskName);
        instance.setTime(plan.getSentTime());
        instance.add(13, 60);
        taskName = StringUtils.join((Object[])new Serializable[]{"RedPacketNoticeMsgTask_", Byte.valueOf(ChatRoomRedPacketNoticeType.D.getType()), "_", plan.getId()});
        this.scheduleService.remove(taskName);
        param = new SentNoticeToChatRoomParam();
        param.setTimingRedPacketPlanId(plan.getId());
        param.setNoticeType(Byte.valueOf(ChatRoomRedPacketNoticeType.D.getType()));
        this.scheduleService.push((ScheduleTask)CronTaskBuilder.builder((String)taskName, (String)StringUtils.join((Object[])new Serializable[]{Integer.valueOf(instance.get(13)), " ", Integer.valueOf(instance.get(12)), " ", Integer.valueOf(instance.get(11)), " * * ?"}), (TaskCallback)this.redPacketNoticeMsgCallback).callbackParam((Object)param).description(StringUtils.join((Object[])new Serializable[]{"id: ", plan.getId(), " \u7ea2\u5305\u53d1\u653e\u540e60\u79d2"})).build());
        return Message.build();
    }

    private Message redPacketRemindTask(ImTimingRedPacketPlan plan) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(plan.getSentTime());
        instance.add(12, -5);
        String taskName = StringUtils.join((Object[])new Serializable[]{"RedPacketRemindTask_", plan.getId()});
        this.scheduleService.remove(taskName);
        RedPacketRemindTaskParam param = new RedPacketRemindTaskParam();
        param.setTimingRedPacketPlanId(plan.getId());
        this.scheduleService.push((ScheduleTask)CronTaskBuilder.builder((String)taskName, (String)StringUtils.join((Object[])new Serializable[]{Integer.valueOf(instance.get(13)), " ", Integer.valueOf(instance.get(12)), " ", Integer.valueOf(instance.get(11)), " * * ?"}), (TaskCallback)this.redPacketRemindCallback).callbackParam((Object)param).description(StringUtils.join((Object[])new Serializable[]{"id: ", plan.getId(), " \u7ea2\u5305\u53d1\u9001\u524d5\u5206\u949f\uff0c\u5411\u7528\u6237\u63a8\u9001"})).build());
        return Message.build();
    }
}

