/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.im.config.RedPacketProperties;
import com.bxm.localnews.im.constant.RedPacketRedisCons;
import com.bxm.localnews.im.domain.ImRedPacketDistributePlanExtendMapper;
import com.bxm.localnews.im.domain.ImRedPacketDistributePlanMapper;
import com.bxm.localnews.im.domain.ImRedPacketDistributeRecordExtendMapper;
import com.bxm.localnews.im.domain.ImRedPacketMapper;
import com.bxm.localnews.im.dto.ImRedPacketInfo;
import com.bxm.localnews.im.dto.RedPackageDetailDto;
import com.bxm.localnews.im.dto.RedPacketDistributePlanInfo;
import com.bxm.localnews.im.dto.RedPacketDistributeRecordInfo;
import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.entry.ImRedPacket;
import com.bxm.localnews.im.entry.ImRedPacketDistributePlan;
import com.bxm.localnews.im.entry.ImRedPacketDistributeRecord;
import com.bxm.localnews.im.integration.UserIntegrationService;
import com.bxm.localnews.im.param.ImRedPacketInfoCacheParam;
import com.bxm.localnews.im.param.RedPackageDetailParam;
import com.bxm.localnews.im.service.RedPacketInfoService;
import com.bxm.localnews.im.service.impl.RedPacketCacheProxyService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RedPacketInfoServiceImpl
implements RedPacketInfoService {
    private static final Logger log = LoggerFactory.getLogger(RedPacketInfoServiceImpl.class);
    @Autowired
    private ImRedPacketMapper imRedPacketMapper;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private RedPacketProperties redPacketProperties;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private ImRedPacketDistributePlanExtendMapper imRedPacketDistributePlanExtendMapper;
    @Autowired
    private ImRedPacketDistributeRecordExtendMapper redPacketDistributeRecordExtendMapper;
    @Autowired
    private RedPacketCacheProxyService redPacketCacheProxyService;

    @Override
    public ImRedPacketInfo loadCache(Long redPacketId) {
        return (ImRedPacketInfo)this.redPacketCacheProxyService.loadCache(ImRedPacketInfoCacheParam.builder().redPacketId(redPacketId).build());
    }

    @Override
    public void clearCache(Long redPacketId) {
        if (Objects.isNull(redPacketId)) {
            log.warn("\u7ea2\u5305id\u4e3a\u7a7a");
            return;
        }
        String redPacketIdStr = Objects.toString(redPacketId);
        this.redisHashMapAdapter.remove(RedPacketRedisCons.RED_PACKET_INFO, new String[]{redPacketIdStr});
    }

    @Override
    public void createRedPacketDistributePlanAndCache(List<ImRedPacketDistributePlan> distributePlans, Long redPacketId) {
        if (CollectionUtils.isEmpty(distributePlans) || Objects.isNull(redPacketId)) {
            log.warn("\u6dfb\u52a0\u7ea2\u5305\u9886\u53d6\u8ba1\u5212\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u6709\u8bef: distributePlans: [{}], redPacketId: [{}]", distributePlans, (Object)redPacketId);
            return;
        }
        Date now = new Date();
        KeyGenerator key = RedPacketRedisCons.RED_PACKET_DISTRIBUTE_PLAN.copy().appendKey((Object)Objects.toString(redPacketId));
        List oldPlans = this.imRedPacketDistributePlanExtendMapper.listByRedPacketId(redPacketId);
        if (!CollectionUtils.isEmpty((Collection)oldPlans)) {
            if (log.isDebugEnabled()) {
                log.debug("redPacketId: [{}] \u5df2\u5b58\u5728\u9886\u53d6\u8ba1\u5212\uff0c\u5148\u7f6e\u4e3a\u5df2\u5220\u9664", (Object)redPacketId);
            }
            ImRedPacketDistributePlan update = new ImRedPacketDistributePlan();
            update.setDeleteTime(now);
            update.setModifyTime(now);
            update.setDeleteFlag(Byte.valueOf((byte)1));
            oldPlans.forEach(p -> {
                update.setId(p.getId());
                this.imRedPacketDistributePlanExtendMapper.updateByPrimaryKeySelective(update);
            });
            this.redisListAdapter.remove(key);
        }
        MybatisBatchBuilder.create(ImRedPacketDistributePlanMapper.class, distributePlans).run(ImRedPacketDistributePlanMapper::insert);
        this.redisListAdapter.leftPush(key, distributePlans);
        this.redisListAdapter.expire(key, this.redPacketProperties.getDistributePlanExpireTime());
    }

    @Override
    public List<RedPacketDistributeRecordInfo> listRedPacketDistributeRecord(Long redPacketId) {
        if (Objects.isNull(redPacketId)) {
            return Lists.newArrayList();
        }
        KeyGenerator key = RedPacketRedisCons.RED_PACKET_DISTRIBUTE_RECORD.copy().appendKey((Object)Objects.toString(redPacketId));
        List infos = this.redisListAdapter.range(key, 0L, -1L, RedPacketDistributeRecordInfo.class);
        if (CollectionUtils.isEmpty((Collection)infos)) {
            infos = Lists.newArrayList();
        }
        return infos;
    }

    @Override
    public RedPacketDistributeRecordInfo addRedPacketDistributeRecord(RedPacketDistributePlanInfo planInfo, Long userId) {
        if (Objects.isNull(planInfo) || Objects.isNull(userId)) {
            log.warn("\u6dfb\u52a0\u9886\u53d6\u8bb0\u5f55\u5931\u8d25\uff0c\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u6c42\u53c2\u6570: info: [{}], userId: [{}]", (Object)planInfo, (Object)userId);
            return null;
        }
        Date now = new Date();
        ImRedPacketDistributeRecord record = new ImRedPacketDistributeRecord();
        record.setAmount(planInfo.getRedPacketAmount());
        record.setRedPacketDistributePlanId(planInfo.getId());
        record.setRedPacketDistributePlanIndex(planInfo.getTIndex());
        record.setRedPacketId(planInfo.getRedPacketId());
        record.setUserId(userId);
        record.setCreateTime(now);
        record.setDeleteFlag(Byte.valueOf((byte)0));
        record.setDeleteTime(null);
        record.setId(this.sequenceCreater.nextLongId());
        record.setModifyTime(now);
        this.redPacketDistributeRecordExtendMapper.insertSelective(record);
        RedPacketDistributeRecordInfo recordInfo = this.convert(record);
        this.redisListAdapter.leftPush(RedPacketRedisCons.RED_PACKET_DISTRIBUTE_RECORD.copy().appendKey((Object)Objects.toString(planInfo.getRedPacketId())), new Object[]{recordInfo});
        return recordInfo;
    }

    @Override
    public RedPacketDistributePlanInfo popPlan(Long redPacketId) {
        if (Objects.isNull(redPacketId)) {
            return null;
        }
        KeyGenerator key = RedPacketRedisCons.RED_PACKET_DISTRIBUTE_PLAN.copy().appendKey((Object)Objects.toString(redPacketId));
        ImRedPacketDistributePlan plan = (ImRedPacketDistributePlan)this.redisListAdapter.rightPop(key, ImRedPacketDistributePlan.class);
        if (Objects.nonNull(plan)) {
            return this.convert(plan);
        }
        return null;
    }

    @Override
    public RedPackageDetailDto redPackageDetail(RedPackageDetailParam param) {
        return (RedPackageDetailDto)this.redPacketCacheProxyService.loadCache(param);
    }

    private RedPacketDistributeRecordInfo convert(ImRedPacketDistributeRecord record) {
        RedPacketDistributeRecordInfo info = new RedPacketDistributeRecordInfo();
        BeanUtils.copyProperties((Object)record, (Object)info);
        UserBean userBean = this.userIntegrationService.selectUserFromCache(record.getUserId());
        if (Objects.nonNull(userBean)) {
            info.setNickName(userBean.getNickname());
            info.setHeadImg(userBean.getHeadImg());
        }
        info.setReceivedTime(((DateFormat)DateUtils.PATTERN_HOUR_MINUTE_SECEND_FORMAT.get()).format(record.getCreateTime()));
        return info;
    }

    private RedPacketDistributePlanInfo convert(ImRedPacketDistributePlan plan) {
        RedPacketDistributePlanInfo planVO = RedPacketDistributePlanInfo.builder().build();
        BeanUtils.copyProperties((Object)plan, (Object)planVO);
        return planVO;
    }

    private ImRedPacketInfo convert(ImRedPacket redPacket) {
        ImRedPacketInfo info = ImRedPacketInfo.builder().build();
        if (Objects.nonNull(redPacket)) {
            BeanUtils.copyProperties((Object)redPacket, (Object)info);
        }
        return info;
    }
}

