/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl;

import com.bxm.localnews.im.domain.UserBlockMapper;
import com.bxm.localnews.im.integration.MsgIntegrationService;
import com.bxm.localnews.im.service.UserBlockService;
import com.bxm.localnews.im.task.ResetIMBlockCallback;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.vo.UserBlockBean;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.builder.OnceTask;
import com.bxm.newidea.component.schedule.builder.OnceTaskBuilder;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserBlockServiceImpl
extends BaseService
implements UserBlockService {
    @Resource
    private UserBlockMapper userBlockMapper;
    @Resource
    private IMSDKAdapter imsdkAdapter;
    @Resource
    private MsgIntegrationService msgIntegrationService;
    @Resource
    private ScheduleService scheduleService;
    @Resource
    private ResetIMBlockCallback resetIMBlockCallback;

    @Override
    public Message add(Long userId, Long blockUserId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((blockUserId != null ? 1 : 0) != 0);
        UserBlockBean entity = UserBlockBean.builder().id(Long.valueOf(this.nextId())).blockUserId(blockUserId).userId(userId).status(Byte.valueOf((byte)1)).createTime(new Date()).build();
        return Message.build((int)this.userBlockMapper.insert(entity));
    }

    @Override
    public Message cancel(Long userId, Long blockUserId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((blockUserId != null ? 1 : 0) != 0);
        return Message.build((int)this.userBlockMapper.cancel(userId, blockUserId));
    }

    @Override
    public Message block(Long userId, int minutes) {
        if (null == userId || minutes <= 0) {
            return Message.build((boolean)false, (String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        Message message = this.imsdkAdapter.block(userId, minutes);
        if (message.isSuccess()) {
            this.logger.debug("\u6dfb\u52a0\u5b9a\u65f6\u89e3\u5c01\u4efb\u52a1\uff0c\u7528\u6237ID\uff1a[{}]\uff0c\u5c01\u7981\u65f6\u957f\uff1a[{}]", (Object)userId, (Object)minutes);
            this.addResetBlock(userId, minutes);
        }
        return message;
    }

    @Override
    public Message unblock(Long userId) {
        if (null == userId) {
            return Message.build((boolean)false, (String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        Message message = this.imsdkAdapter.unblock(userId);
        if (message.isSuccess()) {
            this.msgIntegrationService.addUnblockEvent(userId);
        }
        return message;
    }

    private void addResetBlock(Long userId, int mintues) {
        Date effectiveTime = DateUtils.addField((Date)new Date(), (int)12, (int)mintues);
        effectiveTime = DateUtils.addField((Date)effectiveTime, (int)13, (int)30);
        OnceTask onceTask = OnceTaskBuilder.builder((String)ResetIMBlockCallback.generateTaskName(userId), (Date)effectiveTime, (TaskCallback)this.resetIMBlockCallback).callbackParam((Object)userId).description("\u5b9a\u671f\u89e3\u9664\u7528\u6237\u5c01\u7981\uff0c\u7528\u6237ID\uff1a" + userId).build();
        this.scheduleService.remove(onceTask.taskName());
        this.scheduleService.push((ScheduleTask)onceTask);
    }
}

