/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl.redpacket;

import com.bxm.localnews.im.bo.DistributePlan;
import com.bxm.localnews.im.bo.OpenRedPackageActionParam;
import com.bxm.localnews.im.config.RedPacketProperties;
import com.bxm.localnews.im.constant.RedPacketRedisCons;
import com.bxm.localnews.im.domain.ImChatroomMapper;
import com.bxm.localnews.im.domain.ImRedPacketDistributePlanMapper;
import com.bxm.localnews.im.domain.ImRedPacketMapper;
import com.bxm.localnews.im.dto.ImRedPacketInfo;
import com.bxm.localnews.im.dto.RedPackageDetailDto;
import com.bxm.localnews.im.dto.RedPacketDistributePlanInfo;
import com.bxm.localnews.im.dto.RedPacketDistributeRecordInfo;
import com.bxm.localnews.im.en.RedPacketDistributeArithmeticTypeEn;
import com.bxm.localnews.im.entry.ImRedPacket;
import com.bxm.localnews.im.entry.ImRedPacketDistributePlan;
import com.bxm.localnews.im.param.AccountCashParam;
import com.bxm.localnews.im.param.ImRedPacketCreateParam;
import com.bxm.localnews.im.param.RedPackageDetailParam;
import com.bxm.localnews.im.service.BizLogIntegrationService;
import com.bxm.localnews.im.service.RedPacketInfoService;
import com.bxm.localnews.im.service.UserAccountIntegrationService;
import com.bxm.localnews.im.service.impl.RedPacketCacheProxyService;
import com.bxm.localnews.im.service.impl.redpacket.RedPacketService;
import com.bxm.localnews.im.service.impl.redpacket.strategy.DistributeArithmeticStrategy;
import com.bxm.localnews.im.task.RedPacketRemindCallback;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractRedPacketService
implements RedPacketService,
ApplicationContextAware,
ApplicationRunner {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected ImRedPacketMapper imRedPacketMapper;
    @Autowired
    protected SequenceCreater sequenceCreater;
    @Autowired
    protected ImRedPacketDistributePlanMapper imRedPacketDistributePlanMapper;
    @Autowired
    protected RedPacketInfoService redPacketInfoService;
    @Autowired
    protected RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    protected RedisListAdapter redisListAdapter;
    @Autowired
    protected RedisStringAdapter redisStringAdapter;
    @Autowired
    protected RedPacketProperties redPacketProperties;
    @Autowired
    protected DistributedLock distributedLock;
    @Autowired
    protected IMSDKAdapter imsdkAdapter;
    @Autowired
    protected ImChatroomMapper imChatroomMapper;
    @Autowired
    protected ScheduleService scheduleService;
    @Autowired
    protected RedPacketRemindCallback redPacketRemindCallback;
    @Autowired
    protected RedPacketCacheProxyService redPacketCacheProxyService;
    @Autowired
    protected BizLogIntegrationService bizLogIntegrationService;
    @Autowired
    protected UserAccountIntegrationService userAccountIntegrationService;
    private ApplicationContext applicationContext;
    private static final Map<RedPacketDistributeArithmeticTypeEn, DistributeArithmeticStrategy> DISTRIBUTE_MAP = Maps.newHashMap();

    @Override
    public Message create(ImRedPacketCreateParam param) {
        Message message;
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u521b\u5efa\u7ea2\u5305: [{}]", (Object)param);
        }
        if (!(message = this.createBaseValidate(param)).isSuccess()) {
            this.log.warn("\u521b\u5efa\u7ea2\u5305\u57fa\u672c\u6821\u9a8c\u5931\u8d25, \u8bf7\u6c42\u53c2\u6570: [{}], \u5931\u8d25\u4fe1\u606f: [{}]", (Object)param, (Object)message.getMessages());
            return message;
        }
        try {
            ImRedPacketInfo redPacketInfo = this.doCreate(param);
            if (Objects.nonNull(redPacketInfo)) {
                this.afterCreateSuccess(param, redPacketInfo);
                if (Objects.equals(param.getSentImmediately(), Boolean.TRUE)) {
                    return this.sent(redPacketInfo.getId());
                }
                return Message.build();
            }
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
        }
        this.afterCreateFailed(param);
        return message.setSuccess(false).setMessage("\u521b\u5efa\u7ea2\u5305\u5931\u8d25");
    }

    @Override
    public Message sent(Long redPacketId) {
        Message message;
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u53d1\u9001\u7ea2\u5305: redPacketId: [{}]", (Object)redPacketId);
        }
        ImRedPacketInfo redPacketInfo = this.redPacketInfoService.loadCache(redPacketId);
        try {
            message = this.doSent(redPacketInfo);
        }
        catch (Exception e) {
            this.log.error("\u53d1\u9001\u7ea2\u5305\u6d88\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            message = Message.build((boolean)false).setMessage("\u53d1\u9001\u7ea2\u5305\u51fa\u73b0\u5f02\u5e38");
        }
        if (!message.isSuccess()) {
            this.afterSentFailed(redPacketInfo);
            return message.setSuccess(false).setMessage("\u53d1\u9001\u7ea2\u5305\u5931\u8d25");
        }
        this.afterSentSuccess(redPacketInfo);
        return message;
    }

    @Override
    public RedPackageDetailDto openAndGetInfoIfSuccess(OpenRedPackageActionParam param) {
        Message message = this.openBaseValidate(param);
        if (!message.isSuccess()) {
            this.log.warn("\u9886\u53d6\u7ea2\u5305\u57fa\u672c\u6821\u9a8c\u5931\u8d25, \u8bf7\u6c42\u53c2\u6570: [{}], \u5931\u8d25\u4fe1\u606f: [{}]", (Object)param, (Object)message.getMessages());
            return RedPackageDetailDto.builder().build();
        }
        try {
            message = this.doOpen(param);
            if (!message.isSuccess()) {
                this.log.warn("\u9886\u53d6\u7ea2\u5305\u5931\u8d25, \u8bf7\u6c42\u53c2\u6570: [{}], \u5931\u8d25\u4fe1\u606f: [{}]", (Object)param, (Object)message.getMessages());
                return RedPackageDetailDto.builder().build();
            }
            this.afterOpenSuccess(param);
            RedPackageDetailParam packageDetailParam = new RedPackageDetailParam();
            packageDetailParam.setRedPackageId(param.getRedPacketInfo().getId());
            packageDetailParam.setUserId(param.getUserId());
            return this.redPacketInfoService.redPackageDetail(packageDetailParam);
        }
        catch (Exception e) {
            this.log.error("\u9886\u53d6\u7ea2\u5305\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            return RedPackageDetailDto.builder().build();
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        Collection redPacketServices = this.applicationContext.getBeansOfType(DistributeArithmeticStrategy.class).values();
        redPacketServices.forEach(p -> {
            if (Objects.nonNull(p.support())) {
                DISTRIBUTE_MAP.put(p.support(), (DistributeArithmeticStrategy)p);
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected boolean getOpenLock(String key, String requestId) {
        return this.distributedLock.lock(key, requestId);
    }

    protected void releaseOpenLock(String key, String requestId) {
        this.distributedLock.unlock(key, requestId);
    }

    protected KeyGenerator generatorDistributeKey(OpenRedPackageActionParam param) {
        return RedPacketRedisCons.OPEN_RED_PACKET_LOCK.copy().appendKey((Object)Objects.toString(param.getRedPacketInfo().getId())).appendKey((Object)Objects.toString(param.getUserId()));
    }

    protected Message createBaseValidate(ImRedPacketCreateParam param) {
        if (Objects.isNull(param) || Objects.isNull(param.getRedPacketInfoParam()) || Objects.isNull(param.getSentImmediately())) {
            return Message.build((boolean)false).setMessage("\u521b\u5efa\u7ea2\u5305\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        }
        return Message.build();
    }

    protected Message openBaseValidate(OpenRedPackageActionParam param) {
        if (Objects.isNull(param) || Objects.isNull(param.getRedPacketInfo()) || Objects.isNull(param.getUserId()) || Objects.isNull(param.getRedPacketInfo().getId())) {
            return Message.build((boolean)false).setMessage("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        }
        return Message.build();
    }

    protected RedPacketDistributeRecordInfo saveOpenInfo(OpenRedPackageActionParam param, RedPacketDistributePlanInfo planInfo) {
        RedPacketDistributeRecordInfo info = this.redPacketInfoService.addRedPacketDistributeRecord(planInfo, param.getUserId());
        if (Objects.nonNull(info)) {
            Boolean res;
            AccountCashParam cashParam = new AccountCashParam();
            cashParam.setAddTotal(Boolean.valueOf(true));
            cashParam.setCashType("DRAWABLEL_CASH");
            cashParam.setCash(info.getAmount());
            cashParam.setCashFlowType("IM_CHAT_ROOM_RED_PACKET");
            cashParam.setUserId(param.getUserId());
            cashParam.setRelationId(info.getId());
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u589e\u52a0\u7528\u6237\u91d1\u989d\u548c\u6d41\u6c34\uff0c\u8bf7\u6c42\u53c2\u6570: {}", (Object)cashParam);
            }
            if (Objects.equals(res = this.userAccountIntegrationService.addCash(cashParam), Boolean.FALSE)) {
                this.log.warn("\u589e\u52a0\u7528\u6237: [{}], \u7684\u4f59\u989d\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570: {}", (Object)param.getUserId(), (Object)cashParam);
            }
        }
        return info;
    }

    protected ImRedPacketDistributePlan build(DistributePlan plan, Long redPacketId) {
        Date now = new Date();
        return ImRedPacketDistributePlan.builder().createTime(now).deleteFlag(Byte.valueOf((byte)0)).id(this.sequenceCreater.nextLongId()).tIndex(plan.getIndex()).modifyTime(now).redPacketAmount(plan.getRedPacketAmount()).redPacketId(redPacketId).status(Byte.valueOf((byte)1)).build();
    }

    protected DistributeArithmeticStrategy getStrategy(RedPacketDistributeArithmeticTypeEn typeEn) {
        DistributeArithmeticStrategy strategy = DISTRIBUTE_MAP.get(typeEn);
        if (Objects.isNull(strategy)) {
            this.log.warn("\u7b56\u7565\u7c7b\u578b: [{}]\uff0c\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u7684\u5904\u7406\u7c7b", (Object)typeEn);
        }
        return strategy;
    }

    protected abstract ImRedPacketInfo doCreate(ImRedPacketCreateParam var1);

    protected abstract void afterCreateSuccess(ImRedPacketCreateParam var1, ImRedPacketInfo var2);

    protected abstract void afterCreateFailed(ImRedPacketCreateParam var1);

    protected abstract ImRedPacket saveCreateInfo(ImRedPacketCreateParam var1);

    protected abstract List<ImRedPacketDistributePlan> doCreateDistributePlan(ImRedPacket var1, RedPacketDistributeArithmeticTypeEn var2);

    protected abstract Message doOpen(OpenRedPackageActionParam var1);

    protected abstract void afterOpenSuccess(OpenRedPackageActionParam var1);

    protected abstract Message doSent(ImRedPacketInfo var1);

    protected abstract void afterSentFailed(ImRedPacketInfo var1);

    protected abstract void afterSentSuccess(ImRedPacketInfo var1);
}

