/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl.redpacket;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.im.bo.DistributePlan;
import com.bxm.localnews.im.bo.OpenRedPackageActionParam;
import com.bxm.localnews.im.bo.RedPacketMessage;
import com.bxm.localnews.im.bo.RedPacketMessageContent;
import com.bxm.localnews.im.dto.ImRedPacketInfo;
import com.bxm.localnews.im.dto.RedPacketDistributePlanInfo;
import com.bxm.localnews.im.dto.RedPacketDistributeRecordInfo;
import com.bxm.localnews.im.en.RedPacketAction;
import com.bxm.localnews.im.en.RedPacketAmountTypeName;
import com.bxm.localnews.im.en.RedPacketDistributeArithmeticTypeEn;
import com.bxm.localnews.im.en.RedPacketTypeEn;
import com.bxm.localnews.im.entry.ImRedPacket;
import com.bxm.localnews.im.entry.ImRedPacketDistributePlan;
import com.bxm.localnews.im.param.ImRedPacketCreateParam;
import com.bxm.localnews.im.param.ImRedPacketInfoParam;
import com.bxm.localnews.im.param.RedPacketCacheClearParam;
import com.bxm.localnews.im.service.impl.redpacket.AbstractRedPacketService;
import com.bxm.localnews.im.service.impl.redpacket.strategy.DistributeArithmeticStrategy;
import com.bxm.localnews.im.vo.ImChatroom;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import io.rong.messages.BaseMessage;
import io.rong.models.message.ChatroomMessage;
import io.rong.models.response.ResponseResult;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ChatRoomRedPacketService
extends AbstractRedPacketService {
    @Override
    protected ImRedPacketInfo doCreate(ImRedPacketCreateParam param) {
        Message message = this.createValidate(param);
        if (!message.isSuccess()) {
            this.log.warn("\u521b\u5efa\u7ea2\u5305\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff0c\u521b\u5efa\u53c2\u6570\uff1a [{}], \u5931\u8d25\u4fe1\u606f: [{}]", (Object)param, (Object)message.getMessages());
            return null;
        }
        ImRedPacket imRedPacket = this.saveCreateInfo(param);
        if (Objects.isNull(imRedPacket)) {
            this.log.warn("\u521b\u5efa\u7ea2\u5305\u5931\u8d25\uff0c\u521b\u5efa\u53c2\u6570\uff1a [{}]", (Object)param);
            return null;
        }
        List<ImRedPacketDistributePlan> plans = this.doCreateDistributePlan(imRedPacket, RedPacketDistributeArithmeticTypeEn.getByType((Byte)param.getRedPacketInfoParam().getRedPacketDistributeArithmeticType()));
        if (CollectionUtils.isEmpty(plans)) {
            this.log.warn("\u521b\u5efa\u7ea2\u5305\u6d3e\u53d1\u8ba1\u5212\u5931\u8d25\uff0c\u521b\u5efa\u53c2\u6570\uff1a [{}]");
            return null;
        }
        return this.redPacketInfoService.loadCache(imRedPacket.getId());
    }

    @Override
    protected void afterCreateSuccess(ImRedPacketCreateParam param, ImRedPacketInfo info) {
        this.redPacketCacheProxyService.publish(RedPacketCacheClearParam.builder().redPacketId(info.getId()).action(RedPacketAction.CREATE_RED_PACKET).build());
    }

    @Override
    protected void afterCreateFailed(ImRedPacketCreateParam param) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Message doOpen(OpenRedPackageActionParam param) {
        String requestId = this.sequenceCreater.nextStringId();
        String key = this.generatorDistributeKey(param).gen();
        if (!this.getOpenLock(key, requestId)) {
            return Message.build((boolean)false).setMessage("\u9886\u53d6\u7ea2\u5305\u8bf7\u6c42\u9891\u7e41");
        }
        try {
            ImRedPacketInfo imRedPacketInfo = param.getRedPacketInfo();
            if (Objects.isNull(imRedPacketInfo)) {
                Message message = Message.build((boolean)false).setMessage("\u7ea2\u5305\u4e0d\u5b58\u5728");
                return message;
            }
            Message message = this.openValidate(param, imRedPacketInfo);
            if (!message.isSuccess()) {
                Message message2 = message;
                return message2;
            }
            RedPacketDistributePlanInfo planInfo = this.redPacketInfoService.popPlan(param.getRedPacketInfo().getId());
            if (Objects.isNull(planInfo)) {
                Message message3 = message.setSuccess(false).setMessage("\u7ea2\u5305\u5df2\u88ab\u9886\u53d6\u5b8c");
                return message3;
            }
            RedPacketDistributeRecordInfo recordInfo = this.saveOpenInfo(param, planInfo);
            if (Objects.isNull(recordInfo)) {
                Message message4 = message.setSuccess(false).setMessage("\u9886\u53d6\u7ea2\u5305\u5931\u8d25");
                return message4;
            }
            param.setPlanInfo(planInfo);
            Message message5 = message;
            return message5;
        }
        catch (Exception e) {
            this.log.error("\u9886\u53d6\u7ea2\u5305\u51fa\u73b0\u9519\u8bef", (Throwable)e);
        }
        finally {
            this.releaseOpenLock(key, requestId);
        }
        return Message.build((boolean)false).setMessage("\u9886\u53d6\u7ea2\u5305\u9519\u8bef");
    }

    @Override
    protected void afterOpenSuccess(OpenRedPackageActionParam param) {
        PointReportParam reportParam = PointReportParam.build((BasicParam)param.getBasicParam());
        reportParam.e("3034");
        reportParam.ev(StringUtils.join((Object[])new Serializable[]{"108.", param.getRedPacketInfo().getId()}));
        reportParam.put("uid", String.valueOf(param.getUserId()));
        reportParam.put("a", Objects.toString(param.getAreaCode()));
        this.bizLogIntegrationService.point(reportParam);
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u4e0a\u4f20userId: [{}]\u9886\u53d6\u7ea2\u5305: [{}]\u4e8b\u4ef6\uff0c\u8bf7\u6c42\u53c2\u6570: {}", new Object[]{param.getUserId(), param.getRedPacketInfo().getId(), reportParam});
        }
        if (Objects.equals(param.getRedPacketInfo().getTotalNum().longValue(), param.getPlanInfo().getTIndex().longValue())) {
            this.onRedPacketFinished(param.getRedPacketInfo().getId());
        }
    }

    protected void onRedPacketFinished(Long redPacketId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u7ea2\u5305: [{}]\u9886\u53d6\u5b8c", (Object)redPacketId);
        }
        Date now = new Date();
        ImRedPacket redPacket = new ImRedPacket();
        redPacket.setId(redPacketId);
        redPacket.setFinishTime(now);
        redPacket.setModifyTime(now);
        redPacket.setStatus(Byte.valueOf((byte)2));
        this.imRedPacketMapper.updateByPrimaryKeySelective(redPacket);
        this.redPacketCacheProxyService.publish(RedPacketCacheClearParam.builder().action(RedPacketAction.OPEN_RED_PACKET_FINISHED).redPacketId(redPacketId).delay(Boolean.TRUE).build());
    }

    @Override
    protected Message doSent(ImRedPacketInfo redPacketInfo) {
        String[] chatroomIds = new String[]{redPacketInfo.getTargetId()};
        String typeName = "";
        RedPacketAmountTypeName typeName1 = RedPacketAmountTypeName.getByType((Byte)redPacketInfo.getAmountType());
        if (Objects.nonNull(typeName1)) {
            typeName = typeName1.getDes();
        }
        RedPacketMessageContent content = RedPacketMessageContent.builder().name(redPacketInfo.getRemark()).redPacketId(Objects.toString(redPacketInfo.getId())).typeName(typeName).build();
        RedPacketMessage chatroomMessage = new RedPacketMessage(JSON.toJSONString((Object)content));
        ChatroomMessage message = new ChatroomMessage();
        message.setSenderId(Objects.toString(redPacketInfo.getSourceUserId())).setTargetId(chatroomIds).setContent((BaseMessage)chatroomMessage).setObjectName(chatroomMessage.getType());
        ResponseResult responseResult = this.imsdkAdapter.sentChatRoomMsg(message);
        if (Objects.isNull(responseResult) || !Objects.equals(responseResult.code, 200)) {
            this.log.warn("\u53d1\u9001\u7ea2\u5305\u6d88\u606f\u5931\u8d25\uff01: {}", (Object)responseResult);
            return Message.build((boolean)false).setMessage("\u53d1\u9001\u7ea2\u5305\u6d88\u606f\u5931\u8d25\uff01");
        }
        return Message.build();
    }

    @Override
    protected ImRedPacket saveCreateInfo(ImRedPacketCreateParam param) {
        ImRedPacketInfoParam redPacketInfoParam = param.getRedPacketInfoParam();
        Date now = new Date();
        ImRedPacket imRedPacket = ImRedPacket.builder().amountType(redPacketInfoParam.getAmountType()).authType(redPacketInfoParam.getAuthType()).name(redPacketInfoParam.getName()).remark(redPacketInfoParam.getRemark()).source(redPacketInfoParam.getSource()).sourceUserId(redPacketInfoParam.getSourceUserId()).startTime(now).status(Byte.valueOf((byte)1)).targetId(redPacketInfoParam.getTargetId()).timingRedPacketPlanId(redPacketInfoParam.getTimingRedPacketPlanId()).totalAmount(redPacketInfoParam.getTotalAmount()).totalNum(redPacketInfoParam.getTotalNum()).type(redPacketInfoParam.getType()).deleteFlag(Byte.valueOf((byte)0)).id(this.sequenceCreater.nextLongId()).createTime(now).modifyTime(now).deleteTime(null).finishTime(null).build();
        this.imRedPacketMapper.insertSelective(imRedPacket);
        return imRedPacket;
    }

    @Override
    protected List<ImRedPacketDistributePlan> doCreateDistributePlan(ImRedPacket imRedPacket, RedPacketDistributeArithmeticTypeEn arithmeticType) {
        DistributeArithmeticStrategy strategy = this.getStrategy(arithmeticType);
        if (Objects.nonNull(strategy)) {
            List<DistributePlan> plans = strategy.createPlan(imRedPacket.getTotalAmount(), imRedPacket.getTotalNum());
            List<ImRedPacketDistributePlan> distributePlans = plans.stream().map(p -> this.build((DistributePlan)p, imRedPacket.getId())).collect(Collectors.toList());
            this.redPacketInfoService.createRedPacketDistributePlanAndCache(distributePlans, imRedPacket.getId());
            return distributePlans;
        }
        return Lists.newArrayList();
    }

    protected Message createValidate(ImRedPacketCreateParam param) {
        ImChatroom chatroom = this.imChatroomMapper.selectByChatRoomId(param.getRedPacketInfoParam().getTargetId());
        if (Objects.isNull(chatroom)) {
            return Message.build((boolean)false).setMessage("\u804a\u5929\u5ba4\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(chatroom.getEnableChatRoom().intValue(), 0)) {
            return Message.build((boolean)false).setMessage("\u804a\u5929\u5ba4\u672a\u5f00\u542f");
        }
        if (Objects.equals(chatroom.getEnableTimingRedPacket().intValue(), 0)) {
            return Message.build((boolean)false).setMessage("\u804a\u5929\u5ba4\u672a\u5f00\u542f\u5b9a\u65f6\u7ea2\u5305\u529f\u80fd");
        }
        return Message.build();
    }

    protected Message openValidate(OpenRedPackageActionParam param, ImRedPacketInfo imRedPacketInfo) {
        if (Objects.equals(imRedPacketInfo.getAmountType(), (byte)2)) {
            return Message.build((boolean)false).setMessage("\u7ea2\u5305\u5df2\u9886\u53d6\u5b8c");
        }
        String roomId = imRedPacketInfo.getTargetId();
        List<RedPacketDistributeRecordInfo> recordInfos = this.redPacketInfoService.listRedPacketDistributeRecord(param.getRedPacketInfo().getId());
        if (!CollectionUtils.isEmpty(recordInfos) && recordInfos.stream().filter(p -> Objects.equals(p.getUserId(), param.getUserId())).count() > 0L) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u7528\u6237: [{}]\uff0c\u91cd\u590d\u9886\u53d6\u7ea2\u5305: [{}]", (Object)param.getUserId(), (Object)param.getRedPacketInfo().getId());
            }
            return Message.build((boolean)false).setMessage("\u91cd\u590d\u9886\u53d6");
        }
        return Message.build();
    }

    @Override
    protected void afterSentFailed(ImRedPacketInfo redPacketInfo) {
    }

    @Override
    protected void afterSentSuccess(ImRedPacketInfo redPacketInfo) {
    }

    @Override
    public RedPacketTypeEn support() {
        return RedPacketTypeEn.CHAT_ROOM;
    }
}

