/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl.redpacket;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.im.config.ChatRoomNoticeProperties;
import com.bxm.localnews.im.constant.RedPacketRedisCons;
import com.bxm.localnews.im.domain.ImChatroomMapper;
import com.bxm.localnews.im.domain.ImTimingRedPacketPlanExtendMapper;
import com.bxm.localnews.im.dto.LocationDTO;
import com.bxm.localnews.im.dto.RedPackageDto;
import com.bxm.localnews.im.en.ChatRoomRedPacketNoticeType;
import com.bxm.localnews.im.entry.ImTimingRedPacketPlan;
import com.bxm.localnews.im.integration.LocationIntegrationService;
import com.bxm.localnews.im.param.ChatRoomNearestTimingRedPacketPlanInfoParam;
import com.bxm.localnews.im.param.RedPackageRemindParam;
import com.bxm.localnews.im.param.RedPacketRemindTaskParam;
import com.bxm.localnews.im.param.SentNoticeToChatRoomParam;
import com.bxm.localnews.im.service.PushMsgIntegService;
import com.bxm.localnews.im.service.RedPacketBusinessService;
import com.bxm.localnews.im.service.RedPacketInfoService;
import com.bxm.localnews.im.service.RedPacketReminderService;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.localnews.im.vo.ImChatroom;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import io.rong.messages.BaseMessage;
import io.rong.messages.CustomTxtMessage;
import io.rong.models.message.ChatroomMessage;
import io.rong.models.response.ResponseResult;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RedPacketReminderServiceImpl
implements RedPacketReminderService {
    private static final Logger log = LoggerFactory.getLogger(RedPacketReminderServiceImpl.class);
    @Autowired
    private RedPacketInfoService redPacketInfoService;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private ChatRoomNoticeProperties chatRoomNoticeProperties;
    @Autowired
    private IMSDKAdapter imsdkAdapter;
    @Autowired
    private ImTimingRedPacketPlanExtendMapper imTimingRedPacketPlanExtendMapper;
    @Autowired
    private PushMsgIntegService pushMsgIntegService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private RedPacketBusinessService redPacketBusinessService;
    @Autowired
    private ImChatroomMapper imChatroomMapper;
    @Autowired
    private LocationIntegrationService locationIntegrationService;

    @Override
    public Message remind(RedPackageRemindParam param) {
        ImTimingRedPacketPlan imTimingRedPacketPlan;
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237: [{}]\uff0c\u53d1\u8d77\u63d0\u9192\u8bf7\u6c42: {}", (Object)param.getUserId(), (Object)param);
        }
        if (Objects.nonNull(imTimingRedPacketPlan = this.imTimingRedPacketPlanExtendMapper.selectByPrimaryKey(param.getRedPackageId()))) {
            KeyGenerator key = RedPacketRedisCons.ROOM_TIMING_RED_PACKET_REMINDER_CACHE.copy().appendKey((Object)imTimingRedPacketPlan.getRedPacketTargetId());
            if (Objects.equals(param.getSwitchVal(), Boolean.TRUE)) {
                this.redisHashMapAdapter.put(key, Objects.toString(param.getUserId()), (Object)Objects.toString(param.getRedPackageId()));
            } else {
                this.redisHashMapAdapter.remove(key, new String[]{Objects.toString(param.getUserId())});
            }
        }
        return Message.build();
    }

    @Override
    public boolean hasReminded(Long userId, String chatRoomId) {
        return StringUtils.isNotBlank((CharSequence)((CharSequence)this.redisHashMapAdapter.get(RedPacketRedisCons.ROOM_TIMING_RED_PACKET_REMINDER_CACHE.copy().appendKey((Object)chatRoomId), Objects.toString(userId), String.class)));
    }

    @Override
    public Message sentRedPacketRemindNotice(RedPacketRemindTaskParam param) {
        ImTimingRedPacketPlan imTimingRedPacketPlan = this.imTimingRedPacketPlanExtendMapper.selectByPrimaryKey(param.getTimingRedPacketPlanId());
        if (Objects.isNull(imTimingRedPacketPlan)) {
            return Message.build((boolean)false).setMessage("\u7ea2\u5305\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        ImChatroom chatroom = this.imChatroomMapper.selectByChatRoomId(imTimingRedPacketPlan.getRedPacketTargetId());
        LocationDTO locationDTO = this.locationIntegrationService.getLocationByGeocode(chatroom.getAreaCode());
        if (Objects.isNull(locationDTO)) {
            return Message.build((boolean)false).setMessage("\u804a\u5929\u5ba4\u5bf9\u5e94\u7684\u533a\u57df\u4e0d\u5b58\u5728");
        }
        Message msg = this.checkChatRoomStatus(chatroom);
        if (!msg.isSuccess()) {
            return msg;
        }
        KeyGenerator key = RedPacketRedisCons.ROOM_TIMING_RED_PACKET_REMINDER_CACHE.copy().appendKey((Object)Objects.toString(imTimingRedPacketPlan.getRedPacketTargetId()));
        Set userIds = this.redisHashMapAdapter.keys(key);
        if (!CollectionUtils.isEmpty((Collection)userIds)) {
            String protocol = StringUtils.join((Object[])new String[]{"wst://im/imChatRoom?chatRoomId=", imTimingRedPacketPlan.getRedPacketTargetId()});
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.IM_CHAT_ROOM_TIMING_RED_PACKET_MESSAGE);
            info.setMsgId(this.sequenceCreater.nextLongId());
            info.addExtend("url", (Object)protocol);
            info.addExtend("chatRoomId", (Object)imTimingRedPacketPlan.getRedPacketTargetId());
            info.addExtend("areaCode", (Object)locationDTO.getCode());
            info.addExtend("areaName", (Object)locationDTO.getName());
            info.setProtocol(protocol);
            String content = "\u4eca\u5929" + ((DateFormat)DateUtils.PATTERN_HOUR_MINUTE_FORMAT.get()).format(imTimingRedPacketPlan.getSentTime()) + "\u7684\u7ea2\u5305\u5373\u5c06\u53d1\u653e\uff0c\u901f\u6765\u5f00\u62a2>";
            PushMessage message = PushMessage.build();
            message.setTitle("\u5b9a\u65f6\u7ea2\u5305\u5f00\u62a2\u63d0\u9192");
            message.setContent(content);
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushGroup(new ArrayList(userIds)));
            message.setPayloadInfo(info);
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u9001\u63a8\u9001: {}", (Object)JSON.toJSONString((Object)message));
            }
            this.pushMsgIntegService.pushMsg(message);
        }
        this.redisHashMapAdapter.remove(RedPacketRedisCons.TIMING_RED_PACKET_REMINDER_CACHE.copy().appendKey((Object)Objects.toString(param.getTimingRedPacketPlanId())));
        return Message.build();
    }

    private Message checkChatRoomStatus(ImChatroom chatroom) {
        if (Objects.isNull(chatroom)) {
            return Message.build((boolean)false).setMessage("\u8ba1\u5212\u5bf9\u5e94\u7684\u804a\u5929\u5ba4\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(chatroom.getEnableChatRoom().intValue(), 0)) {
            return Message.build((boolean)false).setMessage("\u804a\u5929\u5ba4\u672a\u5f00\u542f");
        }
        if (Objects.equals(chatroom.getEnableTimingRedPacket().intValue(), 0)) {
            return Message.build((boolean)false).setMessage("\u804a\u5929\u5ba4\u672a\u5f00\u542f\u5b9a\u65f6\u7ea2\u5305\u529f\u80fd");
        }
        return Message.build();
    }

    @Override
    public Message sentNoticeMessageToChatRoom(SentNoticeToChatRoomParam param) {
        Message message1;
        ImTimingRedPacketPlan imTimingRedPacketPlan = this.imTimingRedPacketPlanExtendMapper.selectByPrimaryKey(param.getTimingRedPacketPlanId());
        if (Objects.isNull(imTimingRedPacketPlan)) {
            return Message.build((boolean)false).setMessage("\u7ea2\u5305\u8ba1\u5212\u4e0d\u5b58\u5728");
        }
        ImChatroom chatroom = this.imChatroomMapper.selectByChatRoomId(imTimingRedPacketPlan.getRedPacketTargetId());
        Message msg = this.checkChatRoomStatus(chatroom);
        if (!msg.isSuccess()) {
            return msg;
        }
        String notice = this.chatRoomNoticeProperties.getNotices().get(param.getNoticeType());
        if (StringUtils.isBlank((CharSequence)notice)) {
            return Message.build((boolean)false).setMessage("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u63d0\u9192\u7c7b\u578b");
        }
        if (Objects.equals(ChatRoomRedPacketNoticeType.getByType((Byte)param.getNoticeType()), ChatRoomRedPacketNoticeType.D)) {
            ChatRoomNearestTimingRedPacketPlanInfoParam param1 = new ChatRoomNearestTimingRedPacketPlanInfoParam();
            param1.setChatRoomId(imTimingRedPacketPlan.getRedPacketTargetId());
            RedPackageDto redPackageDto = this.redPacketBusinessService.chatRoomNearestTimingRedPacketPlanInfo(param1);
            notice = Objects.isNull(redPackageDto) ? "" : String.format(notice, StringUtils.join((Object[])new String[]{redPackageDto.getDayStr(), redPackageDto.getTimeStr()}));
        }
        if (StringUtils.isBlank((CharSequence)notice)) {
            log.warn("\u804a\u5929\u5ba4: {} \u6ca1\u6709\u4e0b\u4e00\u4e2a\u7ea2\u5305\uff0c\u4e0d\u53d1\u9001\u9884\u8b66", (Object)imTimingRedPacketPlan.getRedPacketTargetId());
            return Message.build();
        }
        String[] chatroomIds = new String[]{imTimingRedPacketPlan.getRedPacketTargetId()};
        CustomTxtMessage chatroomMessage = new CustomTxtMessage(notice);
        ChatroomMessage message = new ChatroomMessage();
        message.setSenderId(Objects.toString(imTimingRedPacketPlan.getRedPacketSourceUserId())).setTargetId(chatroomIds).setContent((BaseMessage)chatroomMessage).setObjectName(chatroomMessage.getType());
        try {
            ResponseResult responseResult = this.imsdkAdapter.sentChatRoomMsg(message);
            if (Objects.isNull(responseResult) || !Objects.equals(responseResult.code, 200)) {
                log.warn("\u53d1\u9001\u9884\u544a\u6d88\u606f\u5931\u8d25\uff01: {}", (Object)responseResult);
                return Message.build((boolean)false).setMessage("\u53d1\u9001\u9884\u544a\u6d88\u606f\u5931\u8d25\uff01");
            }
            message1 = Message.build();
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5230\u804a\u5929\u5ba4\u5931\u8d25", (Throwable)e);
            message1 = Message.build((boolean)false).setMessage("\u53d1\u9001\u6d88\u606f\u5230\u804a\u5929\u5ba4\u5931\u8d25");
        }
        return message1;
    }
}

