/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl.redpacket.cache;

import com.bxm.localnews.im.config.RedPacketProperties;
import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.integration.UserIntegrationService;
import com.bxm.localnews.im.param.RedPacketCacheClearParam;
import com.bxm.localnews.im.service.RedPacketInfoService;
import com.bxm.localnews.im.service.RedPacketReminderService;
import com.bxm.localnews.im.service.TimingRedPacketPlanService;
import com.bxm.localnews.im.service.impl.RedPacketCacheProxyService;
import com.bxm.localnews.im.service.impl.redpacket.cache.RedPacketCache;
import com.bxm.localnews.im.service.impl.redpacket.cache.RedPacketCacheClearListener;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRedPacketCache<R, P>
implements RedPacketCache<R, P>,
RedPacketCacheClearListener {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected RedPacketCacheProxyService redPacketCacheProxyService;
    @Autowired
    protected RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    protected RedisStringAdapter redisStringAdapter;
    @Autowired
    protected RedisListAdapter redisListAdapter;
    @Autowired
    protected RedPacketProperties redPacketProperties;
    @Autowired
    protected RedPacketInfoService redPacketInfoService;
    @Autowired
    protected UserIntegrationService userIntegrationService;
    @Autowired
    protected TimingRedPacketPlanService timingRedPacketPlanService;
    @Autowired
    protected RedPacketReminderService redPacketReminderService;
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    protected static final long DEFAULT_CHAT_ROOM_PACKET_INFO_TIME = 300L;

    @Override
    public R loadCache(P param) {
        return this.doLoadCache(param);
    }

    @Override
    public void clear(RedPacketCacheClearParam param) {
        if (Objects.equals(param.getDelay(), Boolean.TRUE)) {
            this.scheduledThreadPoolExecutor.schedule(() -> this.doDelayClear(param), param.getDelaySecond(), TimeUnit.SECONDS);
        } else {
            this.doClear(param);
        }
    }

    private void doDelayClear(RedPacketCacheClearParam param) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u5ef6\u8fdf\u6267\u884c\u6e05\u9664\u7f13\u5b58 param: {}", (Object)param);
        }
        try {
            this.doClear(param);
        }
        catch (Exception e) {
            this.log.error("\u6e05\u9664\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    protected UserBean getUserInfoWithDefaultValue(Long userId) {
        UserBean userBean = this.userIntegrationService.selectUserFromCache(userId);
        if (Objects.isNull(userBean)) {
            userBean.setNickname("");
            userBean.setId(userId);
            userBean.setHeadImg("");
        }
        return userBean;
    }

    protected abstract R doLoadCache(P var1);

    protected abstract void doClear(RedPacketCacheClearParam var1);
}

