/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl.redpacket.cache.impl;

import com.bxm.localnews.im.constant.RedPacketRedisCons;
import com.bxm.localnews.im.dto.ImRedPacketInfo;
import com.bxm.localnews.im.dto.RedPackageDetailDto;
import com.bxm.localnews.im.dto.RedPacketDistributeRecordInfo;
import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.dto.WinnerInfoDto;
import com.bxm.localnews.im.param.RedPackageDetailParam;
import com.bxm.localnews.im.param.RedPacketCacheClearParam;
import com.bxm.localnews.im.service.impl.redpacket.cache.AbstractRedPacketCache;
import com.bxm.localnews.im.service.impl.redpacket.cache.annotation.RedPacketCacheAnno;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

@RedPacketCacheAnno(param=RedPackageDetailParam.class)
public class RedPackageDetailDtoCache
extends AbstractRedPacketCache<RedPackageDetailDto, RedPackageDetailParam> {
    @Override
    protected RedPackageDetailDto doLoadCache(RedPackageDetailParam param) {
        Optional<WinnerInfoDto> optional;
        KeyGenerator key = RedPacketRedisCons.RED_PACKET_DETAIL_INFO.copy().appendKey((Object)Objects.toString(param.getRedPackageId()));
        RedPackageDetailDto detailDto = (RedPackageDetailDto)this.redisStringAdapter.get(key, RedPackageDetailDto.class);
        if (Objects.isNull(detailDto) || Objects.nonNull(detailDto.getTotalNum()) && !Objects.equals(detailDto.getReceivedNum(), detailDto.getTotalNum())) {
            ImRedPacketInfo redPacketInfo = this.redPacketInfoService.loadCache(param.getRedPackageId());
            long expireTime = 0L;
            if (Objects.nonNull(redPacketInfo)) {
                Optional<BigDecimal> optional1;
                List<RedPacketDistributeRecordInfo> infos = this.redPacketInfoService.listRedPacketDistributeRecord(param.getRedPackageId());
                BigDecimal receivedAmount = BigDecimal.ZERO;
                Integer receivedNum = 0;
                ArrayList winnerInfoDtos = Lists.newArrayList();
                UserBean userBean = this.getUserInfoWithDefaultValue(redPacketInfo.getSourceUserId());
                if (!CollectionUtils.isEmpty(infos)) {
                    receivedNum = infos.size();
                    optional1 = infos.stream().peek(p -> winnerInfoDtos.add(this.convert((RedPacketDistributeRecordInfo)p))).map(RedPacketDistributeRecordInfo::getAmount).reduce(BigDecimal::add);
                    if (optional1.isPresent()) {
                        receivedAmount = optional1.get();
                    }
                }
                detailDto = RedPackageDetailDto.builder().content(redPacketInfo.getRemark()).receivedAmount(receivedAmount).receivedNum(receivedNum).sender(userBean.getNickname()).senderImg(userBean.getHeadImg()).totalAmount(redPacketInfo.getTotalAmount()).totalNum(redPacketInfo.getTotalNum()).winners((List)winnerInfoDtos).build();
                if (Objects.equals(redPacketInfo.getStatus(), (byte)2)) {
                    if (!CollectionUtils.isEmpty((Collection)winnerInfoDtos) && winnerInfoDtos.size() > 1 && (optional1 = winnerInfoDtos.stream().sorted(Comparator.comparing(WinnerInfoDto::getWinnerPaid).reversed()).findFirst()).isPresent()) {
                        ((WinnerInfoDto)optional1.get()).setLuckyGuy(Boolean.TRUE);
                    }
                    detailDto.setSpendTime(this.getSpendTime(redPacketInfo.getStartTime(), redPacketInfo.getFinishTime()));
                    expireTime = this.redPacketProperties.getRedPacketDetailCacheTime();
                }
            } else {
                detailDto = RedPackageDetailDto.builder().build();
                expireTime = 300L;
            }
            if (expireTime > 0L) {
                this.redisStringAdapter.set(key, (Object)detailDto, expireTime);
            }
        }
        if (Objects.nonNull(detailDto) && !CollectionUtils.isEmpty((Collection)detailDto.getWinners()) && (optional = detailDto.getWinners().stream().filter(p -> Objects.equals(p.getUserId(), Objects.toString(param.getUserId()))).findFirst()).isPresent()) {
            detailDto.setWinnerPaid(optional.get().getWinnerPaid());
        }
        return detailDto;
    }

    @Override
    protected void doClear(RedPacketCacheClearParam param) {
    }

    private String getSpendTime(Date startTime, Date finishTime) {
        if (Objects.isNull(startTime) || Objects.isNull(finishTime)) {
            return "";
        }
        ZoneId zone = ZoneId.systemDefault();
        ZoneOffset zoneOffset = ZoneOffset.of("+8");
        LocalDateTime start = LocalDateTime.ofInstant(startTime.toInstant(), zone);
        LocalDateTime finish = LocalDateTime.ofInstant(finishTime.toInstant(), zone);
        long second = finish.toEpochSecond(zoneOffset) - start.toEpochSecond(zoneOffset);
        if (second < 60L) {
            return StringUtils.join((Object[])new String[]{second + "\u79d2\u88ab\u62a2\u5b8c"});
        }
        if (second > 60L && second < 3600L) {
            return StringUtils.join((Object[])new String[]{second / 60L + "\u5206\u949f\u88ab\u62a2\u5b8c"});
        }
        return "\u5df2\u88ab\u62a2\u5b8c";
    }

    private WinnerInfoDto convert(RedPacketDistributeRecordInfo info) {
        return WinnerInfoDto.builder().headImg(info.getHeadImg()).luckyGuy(Boolean.FALSE).nickName(info.getNickName()).receivedTime(info.getReceivedTime()).userId(Objects.toString(info.getUserId())).winnerPaid(info.getAmount()).build();
    }
}

