/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl.redpacket.cache.impl;

import com.bxm.localnews.im.constant.RedPacketRedisCons;
import com.bxm.localnews.im.dto.ImRedPacketInfo;
import com.bxm.localnews.im.dto.RedPackageStatusDto;
import com.bxm.localnews.im.dto.RedPacketDistributeRecordInfo;
import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.en.RedPacketAction;
import com.bxm.localnews.im.param.RedPackageStatusParam;
import com.bxm.localnews.im.param.RedPacketCacheClearParam;
import com.bxm.localnews.im.service.impl.redpacket.cache.AbstractRedPacketCache;
import com.bxm.localnews.im.service.impl.redpacket.cache.annotation.RedPacketCacheAnno;
import com.bxm.newidea.component.redis.KeyGenerator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@RedPacketCacheAnno(param=RedPackageStatusParam.class, actions={RedPacketAction.CREATE_RED_PACKET, RedPacketAction.OPEN_RED_PACKET_FINISHED})
public class RedPackageStatusDtoCache
extends AbstractRedPacketCache<RedPackageStatusDto, RedPackageStatusParam> {
    @Override
    protected RedPackageStatusDto doLoadCache(RedPackageStatusParam param) {
        KeyGenerator key = RedPacketRedisCons.RED_PACKET_STATUS_INFO.copy().appendKey((Object)Objects.toString(param.getRedPackageId()));
        RedPackageStatusDto statusDto = (RedPackageStatusDto)this.redisStringAdapter.get(key, RedPackageStatusDto.class);
        if (Objects.isNull(statusDto)) {
            ImRedPacketInfo redPacketInfo = this.redPacketInfoService.loadCache(param.getRedPackageId());
            if (Objects.nonNull(redPacketInfo)) {
                UserBean userBean = this.getUserInfoWithDefaultValue(redPacketInfo.getSourceUserId());
                statusDto = RedPackageStatusDto.builder().content(redPacketInfo.getRemark()).id(redPacketInfo.getId()).sender(userBean.getNickname()).status(redPacketInfo.getStatus()).senderImg(userBean.getHeadImg()).build();
            } else {
                statusDto = RedPackageStatusDto.builder().build();
            }
            this.redisStringAdapter.set(key, (Object)statusDto, this.redPacketProperties.getRedPacketStatusCacheTime());
        }
        if (Objects.nonNull(statusDto.getStatus())) {
            List<RedPacketDistributeRecordInfo> redPacketDistributeRecordInfos = this.redPacketInfoService.listRedPacketDistributeRecord(param.getRedPackageId());
            Optional<RedPacketDistributeRecordInfo> optional = redPacketDistributeRecordInfos.stream().filter(p -> Objects.equals(p.getUserId(), param.getUserId())).findFirst();
            Byte status = optional.isPresent() ? Byte.valueOf((byte)2) : Byte.valueOf(Objects.equals(statusDto.getStatus(), (byte)2) ? (byte)0 : 1);
            statusDto.setStatus(status);
        }
        return statusDto;
    }

    @Override
    protected void doClear(RedPacketCacheClearParam param) {
        if (Objects.isNull(param.getRedPacketId())) {
            this.log.warn("\u7ea2\u5305id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6e05\u9664\u72b6\u6001\u4fe1\u606f");
            return;
        }
        KeyGenerator key = RedPacketRedisCons.RED_PACKET_STATUS_INFO.copy().appendKey((Object)Objects.toString(param.getRedPacketId()));
        this.redisStringAdapter.remove(key);
    }
}

