/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.service.impl.redpacket.strategy;

import com.bxm.localnews.im.bo.DistributePlan;
import com.bxm.localnews.im.service.impl.redpacket.strategy.DistributeArithmeticStrategy;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDistributeArithmeticStrategy
implements DistributeArithmeticStrategy {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final BigDecimal MIX_AMT = BigDecimal.valueOf(0.01);
    protected static final BigDecimal MIX_AMT_INT = BigDecimal.valueOf(1L);
    protected static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);

    @Override
    public List<DistributePlan> createPlan(BigDecimal totalAmt, Integer totalNum) {
        if (Objects.isNull(totalAmt) || Objects.isNull(totalNum)) {
            this.log.warn("\u521b\u5efa\u9886\u53d6\u8ba1\u5212\u5931\u8d25\uff01\uff0c\u8bf7\u6c42\u53c2\u6570: totalAmt:[{}], totalNum: [{}]", (Object)totalAmt, (Object)totalNum);
            return Lists.newArrayList();
        }
        BigDecimal totalNumD = BigDecimal.valueOf(totalNum.intValue());
        if (totalNum == 1) {
            ArrayList<DistributePlan> plans = new ArrayList<DistributePlan>(totalNum);
            plans.add(this.build(totalAmt, 1));
            return plans;
        }
        BigDecimal[] results = totalAmt.multiply(ONE_HUNDRED).divideAndRemainder(totalNumD);
        if (results.length > 1) {
            BigDecimal res = results[0];
            if (res.compareTo(BigDecimal.ONE) < 0) {
                this.log.warn("\u603b\u91d1\u989d: [{}]\uff0c\u4e2a\u6570: [{}]\uff0c\u8ba1\u7b97\u540e\u4f4e\u4e8e\u6700\u4f4e\u91d1\u989d0.01\uff0c\u65e0\u6cd5\u751f\u6210\u8ba1\u5212", (Object)totalAmt, (Object)totalNum);
                return Lists.newArrayList();
            }
            BigDecimal remainder = results[1];
            if (remainder.compareTo(BigDecimal.ZERO) == 0 && res.compareTo(BigDecimal.ONE) == 0) {
                ArrayList<DistributePlan> plans = new ArrayList<DistributePlan>(totalNum);
                for (int i = 1; i <= totalNum; ++i) {
                    plans.add(this.build(MIX_AMT, i));
                }
                return plans;
            }
        }
        BigDecimal average = totalAmt.divide(totalNumD, 8, RoundingMode.HALF_DOWN);
        return this.doCreatePlan(totalAmt, totalNumD, average);
    }

    protected DistributePlan build(BigDecimal redPacketAmount, Integer index) {
        return DistributePlan.builder().redPacketAmount(redPacketAmount).index(index).build();
    }

    protected abstract List<DistributePlan> doCreatePlan(BigDecimal var1, BigDecimal var2, BigDecimal var3);
}

