/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.thirdpart.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.im.config.IMProperties;
import com.bxm.localnews.im.dto.UserBean;
import com.bxm.localnews.im.param.ChatRoomMuteParam;
import com.bxm.localnews.im.param.ChatRoomOperationParam;
import com.bxm.localnews.im.param.MessageWithdrawParam;
import com.bxm.localnews.im.thirdpart.IMSDKAdapter;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import io.rong.RongCloud;
import io.rong.methods.chatroom.keepalive.Keepalive;
import io.rong.methods.chatroom.mute.MuteMembers;
import io.rong.methods.chatroom.whitelist.Whitelist;
import io.rong.methods.message._private.Private;
import io.rong.methods.message.chatroom.Chatroom;
import io.rong.models.Result;
import io.rong.models.chatroom.BlockMuteUser;
import io.rong.models.chatroom.ChatroomMember;
import io.rong.models.chatroom.ChatroomModel;
import io.rong.models.message.ChatroomMessage;
import io.rong.models.message.PrivateMessage;
import io.rong.models.message.RecallMessage;
import io.rong.models.response.ChatroomUserQueryResult;
import io.rong.models.response.ListBolckMuteResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.response.TokenResult;
import io.rong.models.user.UserModel;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class RongCloudIMSDK
implements IMSDKAdapter,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RongCloudIMSDK.class);
    private RongCloud rongCloud;
    private final IMProperties imProperties;
    private static final Integer MAX_CHATROOM_MUTE = 43200;

    @Autowired
    public RongCloudIMSDK(IMProperties imProperties) {
        this.imProperties = imProperties;
    }

    @Override
    public String token(UserBean user) {
        UserModel model = this.build(user);
        try {
            log.debug("\u83b7\u53d6\u878d\u4e91token\u5f00\u59cb");
            TokenResult result = this.rongCloud.user.register(model);
            if (this.sussced((Result)result)) {
                log.debug("\u83b7\u53d6\u878d\u4e91token\u6210\u529f,user:[{}],token:[{}]", (Object)user, (Object)result);
                return result.getToken();
            }
            log.error("\u8c03\u7528\u878d\u4e91\u63a5\u53e3\u6ce8\u518c\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a[{}]", (Object)result);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u878d\u4e91rongCloud.user.register\u63a5\u53e3\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private UserModel build(UserBean user) {
        return new UserModel(user.getId().toString(), user.getNickname(), user.getHeadImg());
    }

    private boolean sussced(Result result) {
        return null != result && HttpStatus.OK.value() == result.getCode().intValue();
    }

    @Override
    public void update(UserBean user) {
        try {
            Result result;
            UserModel model = this.build(user);
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237\u4fe1\u606f\u53d8\u66f4\uff0c\u540c\u6b65\u53d8\u66f4\u4fe1\u606f,\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)model);
            }
            if (!this.sussced(result = this.rongCloud.user.update(model))) {
                log.error("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a[{}]", (Object)result);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u878d\u4e91rongCloud.user.update\u63a5\u53e3\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public Message block(Long userId, int mintues) {
        UserModel user = new UserModel();
        user.setMinute(Integer.valueOf(mintues));
        user.setId(String.valueOf(userId));
        try {
            Result result = this.rongCloud.user.block.add(user);
            if (!this.sussced(result)) {
                log.error("\u5c01\u7981\u7528\u6237\u8c03\u7528\u5931\u8d25\uff0c\u5c01\u7981\u7528\u6237\uff1a[{}]\uff0c\u5c01\u7981\u65f6\u957f\uff1a[{}],\u8fd4\u56de\u7ed3\u679c\uff1a[{}]", new Object[]{userId, mintues, result});
                return Message.build((boolean)false);
            }
            log.debug("\u5c01\u7981\u7528\u6237\u6210\u529f\uff0c\u7528\u6237ID:[{}],\u5c01\u7981\u65f6\u957f\uff1a[{}],\u64cd\u4f5c\u7ed3\u679c:[{}]", new Object[]{userId, mintues, result});
        }
        catch (Exception e) {
            log.error("\u5c01\u7981\u7528\u6237\u8c03\u7528\u5931\u8d25\uff0c\u5c01\u7981\u7528\u6237\uff1a[{}]\uff0c\u5c01\u7981\u65f6\u957f\uff1a[{}]", (Object)userId, (Object)mintues);
            log.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false, (String)e.getMessage());
        }
        return Message.build();
    }

    @Override
    public Message unblock(Long userId) {
        try {
            ResponseResult result = this.rongCloud.user.block.remove(String.valueOf(userId));
            if (this.sussced((Result)result)) {
                log.debug("\u89e3\u9664\u5c01\u7981\u7528\u6237\u6210\u529f\uff0c\u7528\u6237ID:[{}],\u64cd\u4f5c\u7ed3\u679c\uff1a[{}]", (Object)userId, (Object)result);
            } else {
                log.error("\u89e3\u9664\u7528\u6237\u5c01\u7981\u5931\u8d25\uff0c\u7528\u6237ID\uff1a[{}]\uff0c\u64cd\u4f5c\u7ed3\u679c\uff1a[{}]", (Object)userId, (Object)result);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u9664\u7528\u6237\u5c01\u7981\u5931\u8d25\uff0c\u7528\u6237ID\uff1a[{}]", (Object)userId);
            log.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false, (String)e.getMessage());
        }
        return Message.build();
    }

    @Override
    public Boolean createChatRoom(String chatRoomId, Long assistantUserIds, String charRoomTitle) {
        Boolean createFlag = false;
        Boolean keepAliveFlag = false;
        io.rong.methods.chatroom.Chatroom chatroom = this.rongCloud.chatroom;
        ChatroomModel chatroomModel = new ChatroomModel().setId(chatRoomId).setName(charRoomTitle);
        ChatroomModel[] chatrooms = new ChatroomModel[]{chatroomModel};
        ResponseResult result = null;
        try {
            result = chatroom.create(chatrooms);
            createFlag = this.sussced((Result)result);
            log.debug("create chatroom:{} ", (Object)result.toString());
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u804a\u5929\u5ba4\u5f02\u5e38", (Throwable)e);
        }
        if (createFlag.booleanValue()) {
            Keepalive keepalive = chatroom.keepalive;
            try {
                ResponseResult addResult = keepalive.add(chatroomModel);
                keepAliveFlag = this.sussced((Result)result);
                log.debug("add keepalive result:{}", (Object)addResult.toString());
            }
            catch (Exception e) {
                log.error("\u804a\u5929\u5ba4\u4fdd\u6d3b\u5f02\u5e38", (Throwable)e);
            }
        }
        Whitelist whitelist = this.rongCloud.chatroom.whiteList;
        ChatroomMember[] members = new ChatroomMember[]{new ChatroomMember().setId(assistantUserIds.toString())};
        ChatroomModel white = new ChatroomModel().setId(chatRoomId).setMembers(members);
        try {
            ResponseResult addResult = whitelist.user.add(white);
            log.debug("add whitelist:[{}]", (Object)addResult.toString());
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u804a\u5929\u5ba4\u767d\u540d\u5355\u5f02\u5e38", (Throwable)e);
        }
        return createFlag != false && keepAliveFlag != false;
    }

    @Override
    public Boolean chatRoomBlock(ChatRoomMuteParam param) {
        try {
            ResponseResult result = this.rongCloud.chatroom.muteMembers.add(this.convert(param));
            return this.sussced((Result)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public Boolean chatRoomUnBlock(ChatRoomOperationParam param) {
        try {
            ResponseResult result = this.rongCloud.chatroom.muteMembers.remove(this.convertOption(param));
            return this.sussced((Result)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private ChatroomModel convertOption(ChatRoomOperationParam param) {
        ChatroomModel chatroomModel = new ChatroomModel();
        chatroomModel.setId(param.getChatRoomId());
        ChatroomMember member = new ChatroomMember();
        member.setChatroomId(param.getChatRoomId());
        member.setId(String.valueOf(param.getTargetUserId()));
        ChatroomMember[] members = new ChatroomMember[]{member};
        chatroomModel.setMembers(members);
        return chatroomModel;
    }

    private ChatroomModel convert(ChatRoomMuteParam param) {
        ChatroomModel chatroomModel = this.convertOption((ChatRoomOperationParam)param);
        if (param.getMinutes() == null || param.getMinutes() < 0 || param.getMinutes() >= MAX_CHATROOM_MUTE) {
            chatroomModel.setMinute(MAX_CHATROOM_MUTE);
        } else {
            chatroomModel.setMinute(param.getMinutes());
        }
        return chatroomModel;
    }

    @Override
    public Boolean deleteChatRoom(String chatRoomId) {
        io.rong.methods.chatroom.Chatroom chatroom = this.rongCloud.chatroom;
        ChatroomModel chatroomModel = new ChatroomModel().setId(chatRoomId);
        ResponseResult chatroomDestroyResult = null;
        try {
            chatroomDestroyResult = chatroom.destroy(chatroomModel);
            log.debug("destroy chatroom: {}", (Object)chatroomDestroyResult.toString());
        }
        catch (Exception e) {
            log.error("\u9500\u6bc1\u804a\u5929\u5ba4\u5f02\u5e38", (Throwable)e);
        }
        return this.sussced((Result)chatroomDestroyResult);
    }

    @Override
    public ChatroomUserQueryResult getChatRoomUser(String chatRoomId) {
        ChatroomModel chatroomModel = new ChatroomModel().setId(chatRoomId).setCount(Integer.valueOf(20)).setOrder(Integer.valueOf(2));
        io.rong.methods.chatroom.Chatroom chatroom = this.rongCloud.chatroom;
        ChatroomUserQueryResult chatroomQueryUserResult = null;
        try {
            chatroomQueryUserResult = chatroom.get(chatroomModel);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u804a\u5929\u6210\u5458\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        return chatroomQueryUserResult;
    }

    @Override
    public ResponseResult sentChatRoomMsg(ChatroomMessage message) {
        Chatroom chatroom = this.rongCloud.message.chatroom;
        ResponseResult chatroomResult = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u9001\u804a\u5929\u5ba4\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)message));
            }
            chatroomResult = chatroom.send(message);
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u9001\u804a\u5929\u5ba4\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c: {}", (Object)chatroomResult);
            }
            return chatroomResult;
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5230\u804a\u5929\u5ba4\u5f02\u5e38", (Throwable)e);
            return chatroomResult;
        }
    }

    @Override
    public List<BlockMuteUser> getChatRoomBlockList(String chatRoomId) {
        MuteMembers muteMembers = this.rongCloud.chatroom.muteMembers;
        try {
            ChatroomModel chatroom = new ChatroomModel().setId(chatRoomId);
            ListBolckMuteResult list = muteMembers.getList(chatroom);
            return list.getUsers();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u804a\u5929\u5ba4\u5c01\u7981\u6210\u5458\u5f02\u5e38", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    @Override
    public Message messageWithdraw(MessageWithdrawParam param) {
        RecallMessage recallMessage = new RecallMessage().setSenderId(String.valueOf(param.getFromUserId())).setTargetId(param.getTargetId()).setuId(param.getMessageUID()).setSentTime(String.valueOf(System.currentTimeMillis()));
        recallMessage.setIsAdmin(1);
        Result recall = null;
        try {
            recall = this.rongCloud.message.chatroom.recall(recallMessage);
        }
        catch (Exception e) {
            log.error("\u64a4\u56de\u804a\u5929\u5ba4\u6d88\u606f\u5f02\u5e38:", (Throwable)e);
        }
        if (Objects.nonNull(recall) && recall.getCode().compareTo(HttpStatus.OK.value()) == 0) {
            return Message.build((boolean)true);
        }
        return Message.build((boolean)false);
    }

    @Override
    public Message batchSendPersonalMessage(PrivateMessage message) {
        Private msgPrivate = this.rongCloud.message.msgPrivate;
        ResponseResult send = null;
        try {
            send = msgPrivate.send(message);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u53d1\u9001\u6d88\u606f\u5f02\u5e38", (Throwable)e);
        }
        return Message.build((boolean)this.sussced((Result)send));
    }

    public void afterPropertiesSet() {
        this.rongCloud = RongCloud.getInstance((String)this.imProperties.getRongcloudAppKey(), (String)this.imProperties.getRongcloudAppSecret());
    }
}

