/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.im.thirdpart.rongcloud;

import com.bxm.localnews.im.thirdpart.MsgContentProcesser;
import com.bxm.localnews.im.thirdpart.rongcloud.DefaultProcesser;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class RCProcesserFactory
implements InitializingBean,
ApplicationContextAware {
    private static Map<String, MsgContentProcesser> processerMap = Maps.newHashMap();
    private ApplicationContext applicationContext;

    public static MsgContentProcesser get(String type) {
        MsgContentProcesser processer = processerMap.get(type);
        if (null == processer) {
            processer = new DefaultProcesser();
        }
        return processer;
    }

    public void afterPropertiesSet() {
        Map processerBeanMap = this.applicationContext.getBeansOfType(MsgContentProcesser.class);
        for (MsgContentProcesser processer : processerBeanMap.values()) {
            processerMap.put(processer.type(), processer);
        }
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

