package com.bxm.localnews.integration.feign;

import com.bxm.localnews.integration.feign.fallback.NewsSearchFallbackFactroy;
import com.bxm.localnews.news.dto.ESNewsContentDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-search", fallbackFactory = NewsSearchFallbackFactroy.class)
public interface NewsSearchFeignService {

    @GetMapping(value = "api/news/search/get")
    ResponseEntity<List<ESNewsContentDTO>> multipleGet(@RequestParam("ids") Long[] ids);

    @PostMapping(value = "api/news/search")
    ResponseEntity<List<ESNewsContentDTO>> search(@RequestParam("keyword") String keyword,
                                                  @RequestParam("pageNum") String pageNum,
                                                  @RequestParam("pageSize") String pageSize);
}
