package com.bxm.localnews.integration.feign.fallback;

import com.bxm.localnews.integration.feign.NewsSearchFeignService;
import com.bxm.localnews.news.dto.ESNewsContentDTO;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class NewsSearchFallbackFactroy implements FallbackFactory<NewsSearchFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsSearchFallbackFactroy.class);

    @Override
    public NewsSearchFeignService create(Throwable throwable) {
        return new NewsSearchFeignService() {
            @Override
            public ResponseEntity<List<ESNewsContentDTO>> multipleGet(Long[] ids) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<List<ESNewsContentDTO>> search(String keyword, String pageNum, String pageSize) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}
