package com.bxm.localnews.integration.feign.fallback;

import com.bxm.localnews.integration.feign.SmsSupplyFeignService;
import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SmsSupplyFallbackFactroy implements FallbackFactory<SmsSupplyFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(SmsSupplyFallbackFactroy.class);

    @Override
    public SmsSupplyFeignService create(Throwable throwable) {
        return new SmsSupplyFeignService() {
            @Override
            public SendSmsResult sendSmsByTemplate(SmsSupplyDTO smsSupplyDTO) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public SendSmsResult sendSmsByCustomize(SmsSupplyDTO smsSupplyDTO) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public void sendGroupSmsByTemplate(SmsSupplyDTO smsSupplyDTO) {
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public void sendGroupSmsByCustomize(SmsSupplyDTO smsSupplyDTO) {
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public Boolean verifySmsCode(String phoneNo, String code, SmsTemplateEnum smsTemplate) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public Boolean verifySmsCodeByType(Byte type, String phoneNo, String code) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public SendSmsResult sendSmsByVCodeTemplate(SmsSupplyDTO smsSupplyDTO) {
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}
