package com.bxm.localnews.market.dto;

import com.bxm.localnews.market.constant.CommissionType;
import com.bxm.localnews.market.constant.CommissionType;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

@Data
@Builder
public class CommissionPlatformFacadeDTO {

    @Tolerate
    public CommissionPlatformFacadeDTO() {
    }

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * vip 自购佣金金额
     */
    private BigDecimal vipPurchasePrice;

    /**
     * 自购佣金金额
     */
    private BigDecimal purchasePrice;

    /**
     * 上级佣金金额
     */
    private BigDecimal parentPrice;

    /**
     * 上上级佣金金额
     */
    private BigDecimal grandParentPrice;

    /**
     * 内容上级佣金金额
     * 万事通独有
     */
    private BigDecimal contentParentPrice;

    /**
     * 内容上上级金额
     * 万事通独有
     */
    private BigDecimal contentGrandParentPrice;

    /**
     * 佣金比例信息
     */
    private PlatformCommissionRageConfigInfo platformCommissionRageConfigInfo;

    /**
     * 佣金的类型
     * @see CommissionType
     */
    private Byte commissionType;

    /**
     * 业务主体 FOSSICKER: 趣淘金 LOCAL_NEWS: 万事通
     */
    private String srcApp;
}
