package com.bxm.localnews.market.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * Created by Administrator on 2018/2/23.
 * 用户信息
 */
@ApiModel(description = "用户实体返回包装类")
@Data
public class UserInfoDTO {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty("年龄")
    private int age;

    @ApiModelProperty("性别")
    private byte sex;

    @ApiModelProperty("等级")
    private byte level;

    @ApiModelProperty("用户访问凭证")
    private String token;

    private long expireTime;

    private String refreshToken;

    private Byte isNew;

    /**
     * 三方是否已绑定 0，未绑定 ；1：已绑定
     */
    private String weibo;

    private String qq;

    private String weixin;

    private Byte state;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date createTime;

    private String phone;

    @ApiModelProperty("生日(精确到日)")
    @JsonFormat(pattern = DateUtils.DATE_FORMAT_YEAR_MONTH_DAY_FORMAT)
    private Date birthday;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty(value = "用户是否使用的临时昵称 ps：0代表不能修改昵称了")
    private Byte isTempNickName;

    @ApiModelProperty("标志位")
    private Long judgeMarker;

    @ApiModelProperty(value = "当前地区编码")
    private String locationCode;

    @ApiModelProperty(value = "当前地区名称")
    private String locationName;

    @ApiModelProperty(value = "当前地区名称-简称 历史遗留原因 locationName存在库内是简称，但对象转换是转成了fullName，所以定义这个字段为简称")
    private String locationShortName;
}