package com.bxm.localnews.market.facade;

import com.bxm.localnews.market.dto.PaymentOrderInfoDTO;
import com.bxm.localnews.market.facade.fallback.PaymentInfoFallbackFactory;
import com.bxm.localnews.market.model.dto.PaymentOrderDTO;
import com.bxm.localnews.market.model.param.order.UserOrderParam;
import com.bxm.localnews.market.param.RefundParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author jieliGG
 * @date : 2020年9月3日 11:13:50
 */
@FeignClient(value = "localnews", fallbackFactory = PaymentInfoFallbackFactory.class, primary = false)
public interface PaymentInfoFeignService {

    @PostMapping("/facade/withdraw/payment/order/create")
    ResponseJson<PaymentOrderDTO> orderCreate(@RequestBody UserOrderParam param);

    @PostMapping("/facade/withdraw/payment/refund")
    ResponseJson<Message> refund(@RequestBody RefundParam param);

    @GetMapping("/facade/payment/pay/getPaymentNumByOrderSn")
    ResponseEntity<PaymentOrderInfoDTO> getPaymentNumByOrderSn(@RequestParam("orderSn") String orderSn);
}
