package com.bxm.localnews.market.facade;

import com.bxm.localnews.market.dto.UserInfoDTO;
import com.bxm.localnews.market.dto.UserInviteHistoryDTO;
import com.bxm.localnews.market.dto.UserPhoneDTO;
import com.bxm.localnews.market.dto.UserTbkInfo;
import com.bxm.localnews.market.facade.fallback.UserFallbackFactory;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-user", fallbackFactory = UserFallbackFactory.class ,primary = false)
public interface UserFeignService {

    /**
     * 获取用户详细信息
     *
     * @param userId
     * @return
     */
    @GetMapping(value = "facade/user/info")
    ResponseEntity<UserInfoDTO> selectUserFromCache(@RequestParam("userId") Long userId);

    /**
     * 9-93-26 根据淘客relation id 获取用户淘客信息
     *
     * @param relationId 淘客relation id
     * @return 淘客信息
     */
    @GetMapping(value = "facade/user/selectUserFromCacheByRelationId")
    ResponseEntity<UserTbkInfo> selectUserFromCacheByRelationId(@RequestParam("relationId") String relationId);

    /**
     * 9-93-27 根据userId 获取用户淘客信息
     *
     * @param userId userId id
     * @return 淘客信息
     */
    @GetMapping(value = "facade/user/selectUserFromCacheByUserId")
    ResponseEntity<UserTbkInfo> selectUserFromCacheByUserId(@RequestParam("userId") Long userId);

    /**
     * 9-93-29 更新标志位
     */
    @GetMapping("facade/user/updateUserJudgeMarker")
    ResponseEntity<Boolean> updateUserJudgeMarker(@RequestParam("userId") Long userId,
                                                  @RequestParam("judgeMarker") LocalNewsUserJudgeMarkerEnum judgeMarker,
                                                  @RequestParam("add") Boolean add);

    /**
     * 根据脱敏手机号码模糊匹配用户
     *
     * @param sensitivePhone 脱敏手机号码 如138****7542
     * @return 用户手机号码信息
     */
    @GetMapping("facade/user/sensitivePhoneUserInfo")
    ResponseEntity<List<UserPhoneDTO>> getUserInfoBySensitivePhone(@RequestParam("sensitivePhone") String sensitivePhone);

    /**
     * 根据手机号码获取用户id
     *
     * @param phone 手机号码
     * @return
     */
    @GetMapping("facade/user/phoneUserInfo")
    ResponseEntity<UserPhoneDTO> getUserInfoByPhone(
            @RequestParam("phone") String phone);

    /***
     * 获取邀请好友的信息
     * @param userId ： 用户id
     * @return ： 返回邀请记录，但是要判断state=1的才是真正的关系哦！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！！
     */
    @GetMapping("facade/user/invite/info")
    ResponseEntity<UserInviteHistoryDTO> getInviteInfo(@RequestParam("userId") Long userId);
}
