package com.bxm.localnews.market.facade;

import com.bxm.localnews.market.facade.fallback.UserVipFallbackFactory;
import com.bxm.localnews.market.param.VipQueryParam;
import com.bxm.localnews.market.model.param.ActivationUserVipParam;
import com.bxm.localnews.user.model.VipInfoDetailDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户vip服务
 *
 * @author wzy
 * @date 2020/8/10 22:50
 **/
@FeignClient(value = "localnews-user", fallbackFactory = UserVipFallbackFactory.class,primary = false)
public interface UserVipFeignService {

    /**
     * 9-89-5 获取用户的vip详细信息
     *
     * @param param vip详细信息查询入参
     * @return vip详细信息
     */
    @PostMapping("facade/user/vip/get/detail")
    ResponseEntity<VipInfoDetailDTO> getVipDetail(@RequestBody VipQueryParam param);
    /**
     * 9-93-33  用户是否是VIP
     *  @param userId : 用户id
     * @return vip详细信息
     */
    @GetMapping("facade/user/isVip")
    ResponseEntity<Boolean> isVip(@RequestParam("userId") Long userId);

    /**
     * 9-89-6 购买vip：用户购买商品的时候勾选的vip
     *  @param param : 入参
     * @return 购买结果
     */
    @PostMapping("facade/user/vip/open/buyVip")
    ResponseEntity<Boolean> buyVip(@RequestBody ActivationUserVipParam param);

}
