package com.bxm.localnews.market.facade;

import com.bxm.localnews.market.dto.PayInfoDTO;
import com.bxm.localnews.market.facade.fallback.WithdrawFallbackFactory;
import com.bxm.newidea.component.vo.Message;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

@FeignClient(value = "localnews", fallbackFactory = WithdrawFallbackFactory.class,primary = false)
public interface WithdrawFeignService {

    @PostMapping("facade/withdraw/manage/applet")
    ResponseEntity<Message> appletWithdraw(@RequestParam("userId") Long userId,
                                           @RequestParam("openId") String openId,
                                           @RequestParam("amount") BigDecimal amount,
                                           @RequestParam("devcId") String devcId,
                                           @RequestParam("ip") String ip);


    @GetMapping("facade/payment/pay/getVipInfo")
    ResponseEntity<PayInfoDTO> getVipInfo();
}
