package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.dto.MerchantRateDTO;
import com.bxm.localnews.market.facade.MerchantGoodsFeignService;
import com.bxm.localnews.market.model.dto.MerchantGoodsInfoDTO;
import com.bxm.localnews.market.model.dto.MerchantOrderInfoDTO;
import com.bxm.localnews.market.model.vo.MerchantInfoSimpleVO;
import com.bxm.localnews.market.param.OperatorMerchantAccountParam;
import feign.hystrix.FallbackFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * 商家商品服务熔断降级
 *
 * @author wzy
 * @date 2020/8/10 23:06
 **/
@Component
public class MerchantGoodsFallbackFactory implements FallbackFactory<MerchantGoodsFeignService> {
    @Override
    public MerchantGoodsFeignService create(Throwable throwable) {
        return new MerchantGoodsFeignService() {
            @Override
            public ResponseEntity<MerchantRateDTO> getMerchantGoodsRate() {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> returnGoodsNum(Long goodsId, Long num) {
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> operatorMerchantAccount(OperatorMerchantAccountParam accountContext) {
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<MerchantGoodsInfoDTO> getMerchantGoodsById(Long goodsId) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> addMerchantOrder(MerchantOrderInfoDTO merchantOrderInfoDTO) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> updateMerchantOrderByNo(MerchantOrderInfoDTO merchantOrderInfoDTO) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<MerchantInfoSimpleVO> getMerchantInfoSimpleInfo(Long goodsId) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> subOrderNum(Long goodsId, Integer num) {
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
