package com.bxm.localnews.market.facade.fallback;


import com.bxm.localnews.market.facade.UserAccountFeignService;
import com.bxm.localnews.market.param.AccountCashParam;
import com.bxm.localnews.market.param.AccountGoldParam;
import com.bxm.localnews.market.param.CashAccountParam;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * 用户账户fallback工厂类
 *
 * @author donghy
 */
@Component
public class UserAccountFallbackFactory implements FallbackFactory<UserAccountFeignService> {

    /**
     * 日志对象
     */
    private static final Logger LOG = LoggerFactory.getLogger(UserAccountFallbackFactory.class);

    @Override
    public UserAccountFeignService create(Throwable throwable) {

        return new UserAccountFeignService() {
            @Override
            public ResponseEntity<Boolean> addGold(AccountGoldParam param) {
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity cashAccountOperation(CashAccountParam param) {
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity cashAccount(AccountCashParam param) {
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
