package com.bxm.localnews.market.facade.fallback;

import com.bxm.localnews.market.dto.UserInfoDTO;
import com.bxm.localnews.market.dto.UserInviteHistoryDTO;
import com.bxm.localnews.market.dto.UserPhoneDTO;
import com.bxm.localnews.market.dto.UserTbkInfo;
import com.bxm.localnews.market.facade.UserFeignService;
import com.bxm.localnews.user.enums.LocalNewsUserJudgeMarkerEnum;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Slf4j
@Component
public class UserFallbackFactory implements FallbackFactory<UserFeignService> {

    @Override
    public UserFeignService create(Throwable throwable) {
        return new UserFeignService() {
            @Override
            public ResponseEntity<UserInfoDTO> selectUserFromCache(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<UserTbkInfo> selectUserFromCacheByRelationId(String relationId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<UserTbkInfo> selectUserFromCacheByUserId(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> updateUserJudgeMarker(Long userId, LocalNewsUserJudgeMarkerEnum judgeMarker, Boolean add) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<List<UserPhoneDTO>> getUserInfoBySensitivePhone(String sensitivePhone) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<UserPhoneDTO> getUserInfoByPhone(String phone) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<UserInviteHistoryDTO> getInviteInfo(Long userId) {
                return ResponseEntity.badRequest().build();
            }
        };
    }
}
